/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;

public class EditComment
implements ChangeListCommand {
    private final String myName;
    private final String myNewComment;
    private String myOldComment;
    private LocalChangeList myListCopy;

    public EditComment(String name, String newComment) {
        this.myNewComment = newComment;
        this.myName = name;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        this.myListCopy = worker.getCopyByName(this.myName);
        if (this.myListCopy != null) {
            this.myOldComment = worker.editComment(this.myName, this.myNewComment);
        }
    }

    @Override
    public void doNotify(EventDispatcher<ChangeListListener> dispatcher) {
        if (this.myListCopy != null) {
            ((ChangeListListener)dispatcher.getMulticaster()).changeListCommentChanged((ChangeList)this.myListCopy, this.myOldComment);
        }
    }

    public String getOldComment() {
        return this.myOldComment;
    }
}

