/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequest;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ShowDiffAction
extends AnAction
implements DumbAware {
    private static final String ourText = ActionsBundle.actionText((String)"ChangesView.Diff");

    public ShowDiffAction() {
        super(ourText, ActionsBundle.actionDescription((String)"ChangesView.Diff"), IconLoader.getIcon((String)"/actions/diff.png"));
    }

    public void update(AnActionEvent e) {
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null && ShowDiffAction.canShowDiff(changes));
    }

    private static boolean canShowDiff(Change[] changes) {
        if (changes == null || changes.length == 0) {
            return false;
        }
        return !ChangesUtil.getFilePath((Change)changes[0]).isDirectory();
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        final Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (project == null || changes == null) {
            return;
        }
        final boolean needsConvertion = this.checkIfThereAreFakeRevisions(project, changes);
        final List changesInList = (List)e.getData(VcsDataKeys.CHANGES_IN_LIST_KEY);
        Runnable performer = new Runnable(){

            @Override
            public void run() {
                Change[] convertedChanges = needsConvertion ? ShowDiffAction.loadFakeRevisions(project, changes) : changes;
                if (convertedChanges == null || convertedChanges.length == 0) {
                    return;
                }
                ArrayList changesInListCopy = changesInList;
                int index = 0;
                if (convertedChanges.length == 1) {
                    Change selectedChange = convertedChanges[0];
                    LocalChangeList changeList = ((ChangeListManagerImpl)ChangeListManager.getInstance((Project)project)).getIdentityChangeList(selectedChange);
                    if (changeList != null) {
                        if (changesInListCopy == null) {
                            changesInListCopy = new ArrayList(changeList.getChanges());
                            Collections.sort(changesInListCopy, new Comparator<Change>(){

                                @Override
                                public int compare(Change o1, Change o2) {
                                    return ChangesUtil.getFilePath((Change)o1).getName().compareToIgnoreCase(ChangesUtil.getFilePath((Change)o2).getName());
                                }
                            });
                        }
                        convertedChanges = changesInListCopy.toArray(new Change[changesInListCopy.size()]);
                        for (int i = 0; i < convertedChanges.length; ++i) {
                            if (convertedChanges[i] != selectedChange) continue;
                            index = i;
                            break;
                        }
                    }
                }
                ShowDiffAction.showDiffForChange(convertedChanges, index, project);
            }
        };
        if (needsConvertion) {
            ChangeListManager.getInstance((Project)project).invokeAfterUpdate(performer, InvokeAfterUpdateMode.BACKGROUND_CANCELLABLE, ourText, ModalityState.current());
        } else {
            performer.run();
        }
    }

    public static void showDiffForChange(Change[] changes, int index, Project project) {
        ShowDiffAction.showDiffForChange(changes, index, project, DiffExtendUIFactory.NONE, true);
    }

    private boolean checkIfThereAreFakeRevisions(Project project, Change[] changes) {
        boolean needsConvertion = false;
        for (Change change : changes) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision instanceof FakeRevision) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(beforeRevision.getFile());
                needsConvertion = true;
            }
            if (!(afterRevision instanceof FakeRevision)) continue;
            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(afterRevision.getFile());
            needsConvertion = true;
        }
        return needsConvertion;
    }

    @Nullable
    private static Change[] loadFakeRevisions(Project project, Change[] changes) {
        ArrayList matchingChanges = new ArrayList();
        for (Change change : changes) {
            matchingChanges.addAll(ChangeListManager.getInstance((Project)project).getChangesIn(ChangesUtil.getFilePath((Change)change)));
        }
        return matchingChanges.toArray(new Change[matchingChanges.size()]);
    }

    public static void showDiffForChange(Iterable<Change> changes, NotNullFunction<Change, Boolean> selectionChecker, final Project project, @Nullable DiffExtendUIFactory actionsFactory, boolean showFrame) {
        int cnt = 0;
        int newIndex = -1;
        ArrayList<Change> changeList = new ArrayList<Change>();
        for (Change change : changes) {
            if (ShowDiffAction.directoryOrBinary(change)) continue;
            changeList.add(change);
            if (newIndex == -1 && ((Boolean)selectionChecker.fun((Object)change)).booleanValue()) {
                newIndex = cnt;
            }
            ++cnt;
        }
        if (changeList.isEmpty()) {
            return;
        }
        if (newIndex < 0) {
            newIndex = 0;
        }
        ShowDiffAction.showDiffImpl(project, ObjectsConvertor.convert(changeList, new Convertor<Change, DiffRequestPresentable>(){

            public ChangeDiffRequestPresentable convert(Change o) {
                return new ChangeDiffRequestPresentable(project, o);
            }
        }), newIndex, actionsFactory, showFrame);
    }

    public static void showDiffForChange(Change[] changes, int index, final Project project, @Nullable DiffExtendUIFactory actionsFactory, boolean showFrame) {
        Change selectedChange = changes[index];
        List<Change> changeList = ShowDiffAction.filterDirectoryAndBinaryChanges(changes);
        if (changeList.isEmpty()) {
            return;
        }
        index = 0;
        for (int i = 0; i < changeList.size(); ++i) {
            if (changeList.get(i) != selectedChange) continue;
            index = i;
            break;
        }
        ShowDiffAction.showDiffImpl(project, ObjectsConvertor.convert(changeList, new Convertor<Change, DiffRequestPresentable>(){

            public ChangeDiffRequestPresentable convert(Change o) {
                return new ChangeDiffRequestPresentable(project, o);
            }
        }), index, actionsFactory, showFrame);
    }

    public static void showDiffImpl(Project project, List<DiffRequestPresentable> changeList, int index, DiffExtendUIFactory actionsFactory, boolean showFrame) {
        ChangeDiffRequest request = new ChangeDiffRequest(project, changeList, actionsFactory, showFrame);
        DiffTool tool = DiffManager.getInstance().getDiffTool();
        if (!request.quickCheckHaveStuff()) {
            return;
        }
        DiffRequest simpleRequest = request.init(index);
        if (simpleRequest != null) {
            tool.show(simpleRequest);
        }
    }

    private static boolean directoryOrBinary(Change change) {
        FilePath path = ChangesUtil.getFilePath((Change)change);
        if (path.isDirectory()) {
            return true;
        }
        FileType type = path.getFileType();
        return !FileTypes.UNKNOWN.equals(type) && type.isBinary();
    }

    private static List<Change> filterDirectoryAndBinaryChanges(Change[] changes) {
        ArrayList<Change> changesList = new ArrayList<Change>();
        Collections.addAll(changesList, changes);
        for (int i = changesList.size() - 1; i >= 0; --i) {
            Change change = changesList.get(i);
            if (!ShowDiffAction.directoryOrBinary(change)) continue;
            changesList.remove(i);
        }
        return changesList;
    }

    private static boolean checkNotifyBinaryDiff(Change selectedChange) {
        ContentRevision beforeRevision = selectedChange.getBeforeRevision();
        ContentRevision afterRevision = selectedChange.getAfterRevision();
        if (beforeRevision instanceof BinaryContentRevision && afterRevision instanceof BinaryContentRevision) {
            try {
                byte[] beforeContent = ((BinaryContentRevision)beforeRevision).getBinaryContent();
                byte[] afterContent = ((BinaryContentRevision)afterRevision).getBinaryContent();
                if (Arrays.equals(beforeContent, afterContent)) {
                    Messages.showInfoMessage((String)VcsBundle.message((String)"message.text.binary.versions.are.identical", (Object[])new Object[0]), (String)VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
                } else {
                    Messages.showInfoMessage((String)VcsBundle.message((String)"message.text.binary.versions.are.different", (Object[])new Object[0]), (String)VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
                }
            }
            catch (VcsException e) {
                Messages.showInfoMessage((String)e.getMessage(), (String)VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    public static interface DiffExtendUIFactory {
        public static final DiffExtendUIFactory NONE = new DiffExtendUIFactory(){

            @Override
            public List<? extends AnAction> createActions(Change change) {
                return Collections.emptyList();
            }

            @Override
            @Nullable
            public JComponent createBottomComponent() {
                return null;
            }
        };

        public List<? extends AnAction> createActions(Change var1);

        @Nullable
        public JComponent createBottomComponent();
    }
}

