/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;

public class TabbedShowHistoryAction
extends AbstractVcsAction {
    @Override
    protected void update(VcsContext context, Presentation presentation) {
        presentation.setEnabled(this.isEnabled(context));
        Project project = context.getProject();
        presentation.setVisible(project != null && ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss().length > 0);
    }

    protected VcsHistoryProvider getProvider(AbstractVcs activeVcs) {
        return activeVcs.getVcsHistoryProvider();
    }

    protected boolean isEnabled(VcsContext context) {
        FilePath[] selectedFiles = TabbedShowHistoryAction.getSelectedFiles(context);
        if (selectedFiles == null) {
            return false;
        }
        if (selectedFiles.length != 1) {
            return false;
        }
        FilePath path = selectedFiles[0];
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        VirtualFile someVFile = path.getVirtualFile() != null ? path.getVirtualFile() : path.getVirtualFileParent();
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(someVFile);
        if (vcs == null) {
            return false;
        }
        VcsHistoryProvider vcsHistoryProvider = this.getProvider(vcs);
        if (vcsHistoryProvider == null) {
            return false;
        }
        if (selectedFiles[0].isDirectory() && !vcsHistoryProvider.supportsHistoryForDirectories()) {
            return false;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(someVFile);
        return fileStatus != FileStatus.ADDED && fileStatus != FileStatus.UNKNOWN;
    }

    protected static FilePath[] getSelectedFiles(VcsContext context) {
        File[] fileArray;
        ArrayList<FilePathImpl> result = new ArrayList<FilePathImpl>();
        VirtualFile[] virtualFileArray = context.getSelectedFiles();
        if (virtualFileArray != null) {
            for (VirtualFile virtualFile : virtualFileArray) {
                result.add(new FilePathImpl(virtualFile));
            }
        }
        if ((fileArray = context.getSelectedIOFiles()) != null) {
            for (File file : fileArray) {
                FilePathImpl child;
                VirtualFile parent;
                File parentIoFile = file.getParentFile();
                if (parentIoFile == null || (parent = LocalFileSystem.getInstance().findFileByIoFile(parentIoFile)) == null || result.contains(child = new FilePathImpl(parent, file.getName(), false))) continue;
                result.add(child);
            }
        }
        return result.toArray(new FilePath[result.size()]);
    }

    @Override
    protected void actionPerformed(VcsContext context) {
        FilePath path = TabbedShowHistoryAction.getSelectedFiles(context)[0];
        Project project = context.getProject();
        VirtualFile someVFile = path.getVirtualFile() != null ? path.getVirtualFile() : path.getVirtualFileParent();
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(someVFile);
        assert (activeVcs != null);
        VcsHistoryProvider vcsHistoryProvider = this.getProvider(activeVcs);
        AbstractVcsHelper.getInstance((Project)project).showFileHistory(vcsHistoryProvider, activeVcs.getAnnotationProvider(), path, null, activeVcs);
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }
}

