/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public abstract class ContentEntryEditingAction
extends ToggleAction
implements CustomComponentAction,
DumbAware {
    protected final JTree myTree;

    protected ContentEntryEditingAction(JTree tree) {
        this.myTree = tree;
        this.getTemplatePresentation().setEnabled(true);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(true);
        VirtualFile[] files = this.getSelectedFiles();
        if (files == null || files.length == 0) {
            presentation.setEnabled(false);
            return;
        }
        for (VirtualFile file : files) {
            if (file != null && file.isDirectory()) continue;
            presentation.setEnabled(false);
            break;
        }
    }

    @Nullable
    protected final VirtualFile[] getSelectedFiles() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null) {
            return null;
        }
        VirtualFile[] selected = new VirtualFile[selectionPaths.length];
        for (int i = 0; i < selectionPaths.length; ++i) {
            TreePath treePath = selectionPaths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object nodeDescriptor = node.getUserObject();
            if (!(nodeDescriptor instanceof FileNodeDescriptor)) {
                return null;
            }
            selected[i] = ((FileNodeDescriptor)((Object)nodeDescriptor)).getElement().getFile();
        }
        return selected;
    }

    public JComponent createCustomComponent(Presentation presentation) {
        return new ActionButtonWithText((AnAction)this, presentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }
}

