/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class SimpleProjectRoot
implements ProjectRoot,
JDOMExternalizable {
    private String myUrl;
    private VirtualFile myFile;
    private final VirtualFile[] myFileArrray = new VirtualFile[1];
    private boolean myInitialized = false;
    @NonNls
    private static final String ATTRIBUTE_URL = "url";

    SimpleProjectRoot(VirtualFile file) {
        this.myFile = file;
        this.myUrl = this.myFile.getUrl();
    }

    public SimpleProjectRoot(String url) {
        this.myUrl = url;
    }

    SimpleProjectRoot() {
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    public String getPresentableString() {
        String path = VirtualFileManager.extractPath((String)this.myUrl);
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - "!/".length());
        }
        return path.replace('/', File.separatorChar);
    }

    @Override
    public VirtualFile[] getVirtualFiles() {
        if (!this.myInitialized) {
            this.initialize();
        }
        if (this.myFile == null) {
            return VirtualFile.EMPTY_ARRAY;
        }
        this.myFileArrray[0] = this.myFile;
        return this.myFileArrray;
    }

    @Override
    public String[] getUrls() {
        return new String[]{this.myUrl};
    }

    @Override
    public boolean isValid() {
        if (!this.myInitialized) {
            this.initialize();
        }
        return this.myFile != null && this.myFile.isValid();
    }

    @Override
    public void update() {
        this.initialize();
    }

    private void initialize() {
        this.myInitialized = true;
        if (this.myFile == null || !this.myFile.isValid()) {
            this.myFile = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
            if (this.myFile != null && this.cantHaveChildren()) {
                this.myFile = null;
            }
        }
    }

    private boolean cantHaveChildren() {
        if (this.myFile.getFileSystem() instanceof HttpFileSystem) {
            return false;
        }
        return !this.myFile.isDirectory();
    }

    public String getUrl() {
        return this.myUrl;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myUrl = element.getAttributeValue(ATTRIBUTE_URL);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (!this.myInitialized) {
            this.initialize();
        }
        element.setAttribute(ATTRIBUTE_URL, this.myUrl);
    }
}

