/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModuleWithDependenciesScope
extends GlobalSearchScope {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope");
    private final Module myModule;
    private final boolean myIncludeLibraries;
    private final boolean myIncludeOtherModules;
    private final boolean myIncludeTests;
    private final ModuleFileIndex myFileIndex;
    private final ProjectFileIndex myProjectFileIndex;
    private final Set<Module> myModules;

    public ModuleWithDependenciesScope(Module module, boolean includeLibraries, boolean includeOtherModules, boolean includeTests) {
        super(module.getProject());
        this.myModule = module;
        this.myIncludeLibraries = includeLibraries;
        this.myIncludeOtherModules = includeOtherModules;
        this.myIncludeTests = includeTests;
        this.myFileIndex = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        if (this.myIncludeOtherModules) {
            this.myModules = new LinkedHashSet<Module>();
            this.myModules.add(this.myModule);
            Module[] dependencies = ModuleRootManager.getInstance((Module)this.myModule).getDependencies(this.myIncludeTests);
            this.myModules.addAll(Arrays.asList(dependencies));
            for (Module dependency : dependencies) {
                this.addExportedModules(dependency);
            }
        } else {
            this.myModules = null;
        }
    }

    private void addExportedModules(Module module) {
        OrderEntry[] orderEntries;
        for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            Module exportedModule;
            if (!orderEntry.isValid() || !(orderEntry instanceof ModuleOrderEntry) || !((ModuleOrderEntry)orderEntry).isExported() || !this.myIncludeTests && ((ModuleOrderEntry)orderEntry).getScope() == DependencyScope.TEST || this.myModules.contains(exportedModule = ((ModuleOrderEntry)orderEntry).getModule())) continue;
            this.myModules.add(exportedModule);
            this.addExportedModules(exportedModule);
        }
    }

    public boolean contains(VirtualFile file) {
        Module module;
        if (!this.myIncludeTests && this.myFileIndex.isInTestSourceContent(file)) {
            return false;
        }
        if (this.myModules != null && (module = this.myProjectFileIndex.getModuleForFile(file)) != null) {
            return this.myModules.contains(module) && this.myFileIndex.getOrderEntryForFile(file) != null && (this.myIncludeTests || !this.myProjectFileIndex.isInTestSourceContent(file));
        }
        List entries = this.myFileIndex.getOrderEntriesForFile(file);
        for (OrderEntry orderEntry : entries) {
            if (this.myIncludeLibraries) {
                if ((orderEntry instanceof LibraryOrderEntry || orderEntry instanceof JdkOrderEntry) && !this.myProjectFileIndex.isInLibraryClasses(file)) continue;
                if (orderEntry instanceof ExportableOrderEntry) {
                    DependencyScope scope = ((ExportableOrderEntry)orderEntry).getScope();
                    if (!this.myIncludeTests && (scope == DependencyScope.TEST || scope == DependencyScope.RUNTIME)) continue;
                }
                if (this.myIncludeOtherModules) {
                    return true;
                }
                if (orderEntry instanceof ModuleOrderEntry) continue;
                return true;
            }
            if (!(this.myIncludeOtherModules ? orderEntry instanceof ModuleSourceOrderEntry || orderEntry instanceof ModuleOrderEntry : orderEntry instanceof ModuleSourceOrderEntry)) continue;
            return true;
        }
        return false;
    }

    public int compare(VirtualFile file1, VirtualFile file2) {
        OrderEntry orderEntry1 = this.myFileIndex.getOrderEntryForFile(file1);
        LOG.assertTrue(orderEntry1 != null);
        OrderEntry orderEntry2 = this.myFileIndex.getOrderEntryForFile(file2);
        LOG.assertTrue(orderEntry2 != null);
        int ret = orderEntry2.compareTo((Object)orderEntry1);
        if (ret != 0) {
            return ret;
        }
        if (this.myModules != null) {
            for (Module module : this.myModules) {
                ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
                ret = fileIndex.isInContent(file1) ? (fileIndex.isInContent(file2) ? 0 : 1) : (fileIndex.isInContent(file2) ? -1 : 0);
                if (ret == 0) continue;
                return ret;
            }
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope.isSearchInModuleContent must not be null");
        }
        if (this.myIncludeOtherModules) {
            return this.myModules.contains(aModule);
        }
        return aModule == this.myModule;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope.isSearchInModuleContent must not be null");
        }
        return this.isSearchInModuleContent(aModule) && (this.myIncludeTests || !testSources);
    }

    public boolean isSearchInLibraries() {
        return this.myIncludeLibraries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleWithDependenciesScope)) {
            return false;
        }
        ModuleWithDependenciesScope moduleWithDependenciesScope = (ModuleWithDependenciesScope)((Object)o);
        if (!this.myModule.equals(moduleWithDependenciesScope.myModule)) {
            return false;
        }
        if (this.myIncludeLibraries != moduleWithDependenciesScope.myIncludeLibraries) {
            return false;
        }
        if (this.myIncludeOtherModules != moduleWithDependenciesScope.myIncludeOtherModules) {
            return false;
        }
        return this.myIncludeTests == moduleWithDependenciesScope.myIncludeTests;
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }

    @NonNls
    public String toString() {
        return "Module with dependencies:" + this.myModule.getName() + " include libraries:" + this.myIncludeLibraries + " include other modules:" + this.myIncludeOtherModules + " include tests:" + this.myIncludeTests;
    }

    public String getDisplayName() {
        return PsiBundle.message((String)"psi.search.scope.module", (Object[])new Object[]{this.myModule.getName()});
    }
}

