/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KeymapManager", roamingType=RoamingType.PER_PLATFORM, storages={@Storage(id="keymap", file="$APP_CONFIG$/keymap.xml")})
public class KeymapManagerImpl
extends KeymapManagerEx
implements PersistentStateComponent<Element>,
ExportableApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.keymap.KeymapManager");
    private final List<KeymapManagerListener> myListeners = ContainerUtil.createEmptyCOWList();
    private String myActiveKeymapName;
    private final Map<String, String> myBoundShortcuts = new HashMap<String, String>();
    @NonNls
    private static final String KEYMAP = "keymap";
    @NonNls
    private static final String KEYMAPS = "keymaps";
    @NonNls
    private static final String ACTIVE_KEYMAP = "active_keymap";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    private final SchemesManager<Keymap, KeymapImpl> mySchemesManager;
    public static boolean ourKeymapManagerInitialized = false;

    KeymapManagerImpl(DefaultKeymap defaultKeymap, SchemesManagerFactory factory) {
        Keymap[] keymaps;
        this.mySchemesManager = factory.createSchemesManager("$ROOT_CONFIG$/keymaps", (SchemeProcessor)new SchemeProcessor<KeymapImpl>(){

            public KeymapImpl readScheme(Document schemeContent) throws InvalidDataException, IOException, JDOMException {
                return KeymapManagerImpl.this.readKeymap(schemeContent);
            }

            public Document writeScheme(KeymapImpl scheme) throws WriteExternalException {
                return new Document(scheme.writeExternal());
            }

            public boolean shouldBeSaved(KeymapImpl scheme) {
                return scheme.canModify();
            }

            public void initScheme(KeymapImpl scheme) {
            }

            public void onSchemeAdded(KeymapImpl scheme) {
            }

            public void onSchemeDeleted(KeymapImpl scheme) {
            }

            public void onCurrentSchemeChanged(Scheme newCurrentScheme) {
            }
        }, RoamingType.PER_USER);
        for (Keymap keymap : keymaps = defaultKeymap.getKeymaps()) {
            String systemDefaultKeymap;
            this.addKeymap(keymap);
            String string = systemDefaultKeymap = SystemInfo.isMac ? "Mac OS X" : "$default";
            if (!systemDefaultKeymap.equals(keymap.getName())) continue;
            this.setActiveKeymap(keymap);
        }
        this.load();
        ourKeymapManagerInitialized = true;
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{new File(PathManager.getOptionsPath() + File.separatorChar + "keymap.xml"), KeymapManagerImpl.getKeymapDirectory(true)};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/keymap/impl/KeymapManagerImpl.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = KeyMapBundle.message((String)"key.maps.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/keymap/impl/KeymapManagerImpl.getPresentableName must not return null");
        }
        return string;
    }

    @Override
    public Keymap[] getAllKeymaps() {
        List keymaps = this.mySchemesManager.getAllSchemes();
        return keymaps.toArray(new Keymap[keymaps.size()]);
    }

    @Nullable
    public Keymap getKeymap(String name) {
        return (Keymap)this.mySchemesManager.findSchemeByName(name);
    }

    public Keymap getActiveKeymap() {
        return (Keymap)this.mySchemesManager.getCurrentScheme();
    }

    @Override
    public void setActiveKeymap(Keymap activeKeymap) {
        this.mySchemesManager.setCurrentSchemeName(activeKeymap == null ? null : activeKeymap.getName());
        this.fireActiveKeymapChanged();
    }

    @Override
    public void bindShortcuts(String sourceActionId, String targetActionId) {
        this.myBoundShortcuts.put(targetActionId, sourceActionId);
    }

    @Override
    public Set<String> getBoundActions() {
        return this.myBoundShortcuts.keySet();
    }

    @Override
    public String getActionBinding(String actionId) {
        return this.myBoundShortcuts.get(actionId);
    }

    @Override
    public SchemesManager<Keymap, KeymapImpl> getSchemesManager() {
        return this.mySchemesManager;
    }

    public void addKeymap(Keymap keymap) {
        this.mySchemesManager.addNewScheme((Scheme)keymap, true);
    }

    public void removeAllKeymapsExceptUnmodifiable() {
        for (Keymap keymap : this.mySchemesManager.getAllSchemes()) {
            if (!keymap.canModify()) continue;
            this.mySchemesManager.removeScheme((Scheme)keymap);
        }
        this.mySchemesManager.setCurrentSchemeName(null);
        List keymaps = this.mySchemesManager.getAllSchemes();
        if (keymaps.size() > 0) {
            this.mySchemesManager.setCurrentSchemeName(((Keymap)keymaps.iterator().next()).getName());
        }
    }

    public String getExternalFileName() {
        return KEYMAP;
    }

    public Element getState() {
        Element result = new Element("component");
        try {
            this.writeExternal(result);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        Keymap keymap;
        Element child = element.getChild(ACTIVE_KEYMAP);
        if (child != null) {
            this.myActiveKeymapName = child.getAttributeValue(NAME_ATTRIBUTE);
        }
        if (this.myActiveKeymapName != null && (keymap = this.getKeymap(this.myActiveKeymapName)) != null) {
            this.setActiveKeymap(keymap);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.mySchemesManager.getCurrentScheme() != null) {
            Element e = new Element(ACTIVE_KEYMAP);
            Keymap currentScheme = (Keymap)this.mySchemesManager.getCurrentScheme();
            if (currentScheme != null) {
                e.setAttribute(NAME_ATTRIBUTE, currentScheme.getName());
            }
            element.addContent(e);
        }
    }

    private void load() {
        this.mySchemesManager.loadSchemes();
    }

    private KeymapImpl readKeymap(Document document) throws JDOMException, InvalidDataException, IOException {
        if (document == null) {
            throw new InvalidDataException();
        }
        Element root = document.getRootElement();
        if (root == null || !KEYMAP.equals(root.getName())) {
            throw new InvalidDataException();
        }
        KeymapImpl keymap = new KeymapImpl();
        keymap.readExternal(root, this.getAllKeymaps());
        return keymap;
    }

    @Nullable
    private static File getKeymapDirectory(boolean toCreate) {
        String directoryPath = PathManager.getConfigPath() + File.separator + KEYMAPS;
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            if (!toCreate) {
                return null;
            }
            if (!directory.mkdir()) {
                LOG.error("Cannot create directory: " + directory.getAbsolutePath());
                return null;
            }
        }
        return directory;
    }

    private void fireActiveKeymapChanged() {
        for (KeymapManagerListener listener : this.myListeners) {
            listener.activeKeymapChanged((Keymap)this.mySchemesManager.getCurrentScheme());
        }
    }

    public void addKeymapManagerListener(KeymapManagerListener listener) {
        this.myListeners.add(listener);
    }

    public void removeKeymapManagerListener(KeymapManagerListener listener) {
        this.myListeners.remove(listener);
    }

    @NotNull
    public String getComponentName() {
        if ("KeymapManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/keymap/impl/KeymapManagerImpl.getComponentName must not return null");
        }
        return "KeymapManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

