/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import java.beans.PropertyChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentDocument
extends UserDataHolderBase
implements Document {
    private final JTextComponent myTextComponent;

    public TextComponentDocument(JTextComponent textComponent) {
        this.myTextComponent = textComponent;
    }

    public String getText() {
        try {
            javax.swing.text.Document document = this.myTextComponent.getDocument();
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public CharSequence getCharsSequence() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/textarea/TextComponentDocument.getCharsSequence must not return null");
        }
        return string;
    }

    @NotNull
    public char[] getChars() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getTextLength() {
        return this.myTextComponent.getDocument().getLength();
    }

    public int getLineCount() {
        return 1;
    }

    public int getLineNumber(int offset) {
        return 0;
    }

    public int getLineStartOffset(int line) {
        return 0;
    }

    public int getLineEndOffset(int line) {
        return this.getTextLength();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentDocument.insertString must not be null");
        }
        try {
            this.myTextComponent.getDocument().insertString(offset, ((Object)s).toString(), null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        try {
            this.myTextComponent.getDocument().remove(startOffset, endOffset - startOffset);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentDocument.replaceString must not be null");
        }
        javax.swing.text.Document document = this.myTextComponent.getDocument();
        try {
            document.remove(startOffset, endOffset - startOffset);
            document.insertString(startOffset, ((Object)s).toString(), null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isWritable() {
        return true;
    }

    public long getModificationStamp() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void fireReadOnlyModificationAttempt() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentDocument.addDocumentListener must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentDocument.addDocumentListener must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentDocument.addDocumentListener must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentDocument.removeDocumentListener must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public MarkupModel getMarkupModel(@Nullable Project project) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentDocument.addPropertyChangeListener must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentDocument.removePropertyChangeListener must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setReadOnly(boolean isReadOnly) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentDocument.removeGuardedBlock must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public RangeMarker getOffsetGuard(int offset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public RangeMarker getRangeGuard(int start, int end) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void startGuardedBlockChecking() {
    }

    public void stopGuardedBlockChecking() {
    }

    public void setCyclicBufferSize(int bufferSize) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentDocument.setText must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentDocument.createRangeMarker must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getLineSeparatorLength(int line) {
        return 0;
    }
}

