/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.SimpleChange;
import com.intellij.openapi.diff.impl.splitter.LineBlocks;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ChangeList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.ChangeList");
    private static final Comparator<Change> CHANGE_ORDER = new Change.ChangeOrder(FragmentSide.SIDE1);
    private final Document[] myDocuments = new Document[2];
    private final Parent myParent;
    private final ArrayList<Listener> myListeners = new ArrayList();
    private ArrayList<Change> myChanges;

    public ChangeList(Document base, Document version, Parent parent) {
        this.myDocuments[0] = base;
        this.myDocuments[1] = version;
        this.myParent = parent;
    }

    public void addListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        LOG.assertTrue(this.myListeners.remove(listener));
    }

    public void setChanges(ArrayList<Change> changes) {
        if (this.myChanges != null) {
            HashSet newChanges = new HashSet(changes);
            LOG.assertTrue(newChanges.size() == changes.size());
            Iterator<Change> iterator = this.myChanges.iterator();
            while (iterator.hasNext()) {
                Change oldChange = iterator.next();
                if (newChanges.contains((Object)oldChange)) continue;
                iterator.remove();
                oldChange.onRemovedFromList();
            }
        }
        for (Change change : changes) {
            LOG.assertTrue(change.isValid());
        }
        this.myChanges = new ArrayList<Change>(changes);
    }

    public Project getProject() {
        return this.myParent.getProject();
    }

    public List<Change> getChanges() {
        return Collections.unmodifiableList(this.myChanges);
    }

    public static ChangeList build(Document base, Document version, Parent parent) {
        ChangeList result = new ChangeList(base, version, parent);
        ArrayList<Change> changes = result.buildChanges();
        Collections.sort(changes, CHANGE_ORDER);
        result.setChanges(changes);
        return result;
    }

    public void setMarkup(Editor base, Editor version) {
        Editor[] editors = new Editor[]{base, version};
        for (Change change : this.myChanges) {
            change.addMarkup(editors);
        }
    }

    public void updateMarkup() {
        for (Change change : this.myChanges) {
            change.updateMarkup();
        }
    }

    public Document getDocument(FragmentSide side) {
        return this.myDocuments[side.getIndex()];
    }

    private ArrayList<Change> buildChanges() {
        Document base = this.getDocument(FragmentSide.SIDE1);
        String[] baseLines = DiffUtil.convertToLines(base.getText());
        Document version = this.getDocument(FragmentSide.SIDE2);
        String[] versionLines = DiffUtil.convertToLines(version.getText());
        DiffFragment[] fragments = ComparisonPolicy.DEFAULT.buildDiffFragmentsFromLines(baseLines, versionLines);
        final ArrayList<Change> result = new ArrayList<Change>();
        new DiffFragmemntsEnumerator(fragments){

            @Override
            protected void process(DiffFragment fragment) {
                if (fragment.isEqual()) {
                    return;
                }
                Context context = this.getContext();
                TextRange range1 = context.createRange(FragmentSide.SIDE1);
                TextRange range2 = context.createRange(FragmentSide.SIDE2);
                result.add(new SimpleChange(ChangeType.fromDiffFragment(context.getFragment()), range1, range2, ChangeList.this));
            }
        }.execute();
        return result;
    }

    public Change getChange(int index) {
        return this.myChanges.get(index);
    }

    public int getCount() {
        return this.myChanges.size();
    }

    public LineBlocks getLineBlocks() {
        return LineBlocks.fromChanges(this.myChanges);
    }

    public void remove(Change change) {
        LOG.assertTrue(this.myChanges.remove(change), (Object)change);
        change.onRemovedFromList();
        this.fireOnChangeRemoved();
    }

    private void fireOnChangeRemoved() {
        Listener[] listeners;
        for (Listener listener : listeners = this.myListeners.toArray(new Listener[this.myListeners.size()])) {
            listener.onChangeRemoved(this);
        }
    }

    public static interface Listener {
        public void onChangeRemoved(ChangeList var1);
    }

    public static interface Parent {
        public Project getProject();
    }

    public static class Context {
        private DiffFragment myFragment;
        private final int[] myStarts = new int[]{0, 0};
        private final int[] myLines = new int[]{0, 0};

        public DiffFragment getFragment() {
            return this.myFragment;
        }

        public int getStart(FragmentSide side) {
            return this.myStarts[side.getIndex()];
        }

        public int getEnd(FragmentSide side) {
            return this.getStart(side) + DiffUtil.getTextLength(side.getText(this.myFragment));
        }

        public TextRange createRange(FragmentSide side) {
            return new TextRange(this.getStart(side), this.getEnd(side));
        }
    }

    private static abstract class DiffFragmemntsEnumerator {
        private final DiffFragment[] myFragments;
        private final Context myContext = new Context();

        private DiffFragmemntsEnumerator(DiffFragment[] fragments) {
            this.myFragments = fragments;
        }

        public void execute() {
            for (DiffFragment fragment : this.myFragments) {
                this.myContext.myFragment = fragment;
                this.process(fragment);
                String text1 = fragment.getText1();
                String text2 = fragment.getText2();
                int[] nArray = this.myContext.myStarts;
                nArray[0] = nArray[0] + DiffUtil.getTextLength(text1);
                int[] nArray2 = this.myContext.myStarts;
                nArray2[1] = nArray2[1] + DiffUtil.getTextLength(text2);
                int[] nArray3 = this.myContext.myLines;
                nArray3[0] = nArray3[0] + DiffFragmemntsEnumerator.countLines(text1);
                int[] nArray4 = this.myContext.myLines;
                nArray4[1] = nArray4[1] + DiffFragmemntsEnumerator.countLines(text2);
            }
        }

        private static int countLines(String text) {
            if (text == null) {
                return 0;
            }
            return StringUtil.countNewLines((CharSequence)text);
        }

        protected Context getContext() {
            return this.myContext;
        }

        protected abstract void process(DiffFragment var1);
    }
}

