/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentStoreImpl;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.ProjectStoreImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.fs.IFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ProjectWithModulesStoreImpl
extends ProjectStoreImpl {
    public ProjectWithModulesStoreImpl(ProjectEx project) {
        super(project);
    }

    @Override
    public void reinitComponents(Set<String> componentNames, boolean reloadData) {
        super.reinitComponents(componentNames, reloadData);
        for (Module module : this.getPersistentModules()) {
            ((ModuleImpl)module).getStateStore().reinitComponents(componentNames, reloadData);
        }
    }

    @Override
    public TrackingPathMacroSubstitutor[] getSubstitutors() {
        ArrayList<TrackingPathMacroSubstitutor> result = new ArrayList<TrackingPathMacroSubstitutor>();
        result.add(this.getStateStorageManager().getMacroSubstitutor());
        for (Module module : this.getPersistentModules()) {
            result.add(((ModuleImpl)module).getStateStore().getStateStorageManager().getMacroSubstitutor());
        }
        return result.toArray(new TrackingPathMacroSubstitutor[result.size()]);
    }

    @Override
    public boolean isReloadPossible(Set<String> componentNames) {
        if (!super.isReloadPossible(componentNames)) {
            return false;
        }
        for (Module module : this.getPersistentModules()) {
            if (((ModuleImpl)module).getStateStore().isReloadPossible(componentNames)) continue;
            return false;
        }
        return true;
    }

    protected Module[] getPersistentModules() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        if (moduleManager == null) {
            return Module.EMPTY_ARRAY;
        }
        return moduleManager.getModules();
    }

    @Override
    protected ComponentStoreImpl.SaveSessionImpl createSaveSession() throws StateStorage.StateStorageException {
        return new ProjectWithModulesSaveSession();
    }

    private class ProjectWithModulesSaveSession
    extends ProjectStoreImpl.ProjectSaveSession {
        List<IComponentStore.SaveSession> myModuleSaveSessions = new ArrayList<IComponentStore.SaveSession>();

        public ProjectWithModulesSaveSession() throws StateStorage.StateStorageException {
            try {
                for (Module module : ProjectWithModulesStoreImpl.this.getPersistentModules()) {
                    this.myModuleSaveSessions.add(((ModuleImpl)module).getStateStore().startSave());
                }
            }
            catch (IOException e) {
                throw new StateStorage.StateStorageException(e.getMessage());
            }
        }

        @Override
        public List<IFile> getAllStorageFiles(boolean includingSubStructures) {
            List<IFile> result = super.getAllStorageFiles(includingSubStructures);
            if (includingSubStructures) {
                for (IComponentStore.SaveSession moduleSaveSession : this.myModuleSaveSessions) {
                    result.addAll(moduleSaveSession.getAllStorageFiles(true));
                }
            }
            return result;
        }

        @Override
        @Nullable
        public Set<String> analyzeExternalChanges(Set<Pair<VirtualFile, StateStorage>> changedFiles) {
            Set<String> result = super.analyzeExternalChanges(changedFiles);
            if (result == null) {
                return null;
            }
            for (IComponentStore.SaveSession moduleSaveSession : this.myModuleSaveSessions) {
                Set<String> s = moduleSaveSession.analyzeExternalChanges(changedFiles);
                if (s == null) {
                    return null;
                }
                result.addAll(s);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishSave() {
            try {
                Throwable first = null;
                for (IComponentStore.SaveSession moduleSaveSession : this.myModuleSaveSessions) {
                    try {
                        moduleSaveSession.finishSave();
                    }
                    catch (Throwable e) {
                        if (first != null) continue;
                        first = e;
                    }
                }
                if (first != null) {
                    throw new RuntimeException(first);
                }
            }
            finally {
                super.finishSave();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            try {
                for (IComponentStore.SaveSession moduleSaveSession : this.myModuleSaveSessions) {
                    moduleSaveSession.reset();
                }
            }
            finally {
                super.reset();
            }
        }

        @Override
        protected void beforeSave() throws IOException {
            super.beforeSave();
            for (IComponentStore.SaveSession moduleSaveSession : this.myModuleSaveSessions) {
                moduleSaveSession.save();
            }
        }

        @Override
        protected void collectSubfilesToSave(List<IFile> result) throws IOException {
            for (IComponentStore.SaveSession moduleSaveSession : this.myModuleSaveSessions) {
                List<IFile> moduleFiles = moduleSaveSession.getAllStorageFilesToSave(true);
                result.addAll(moduleFiles);
            }
        }
    }
}

