/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.StripeTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class NotificationsConfigurablePanel
extends JPanel
implements Disposable {
    private NotificationsTable myTable;
    private static final String REMOVE_KEY = "REMOVE";

    public NotificationsConfigurablePanel() {
        this.setLayout(new BorderLayout());
        this.myTable = new NotificationsTable();
        this.add((Component)StripeTable.createScrollPane((JTable)((Object)this.myTable)), "Center");
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), REMOVE_KEY);
        this.myTable.getActionMap().put(REMOVE_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationsConfigurablePanel.this.removeSelected();
            }
        });
    }

    private void removeSelected() {
        this.myTable.removeSelected();
    }

    public void dispose() {
        this.myTable = null;
    }

    public boolean isModified() {
        List<SettingsWrapper> list = this.myTable.getAllSettings();
        for (SettingsWrapper settingsWrapper : list) {
            if (!settingsWrapper.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        List<SettingsWrapper> list = this.myTable.getAllSettings();
        for (SettingsWrapper settingsWrapper : list) {
            settingsWrapper.apply();
        }
    }

    public void reset() {
        List<SettingsWrapper> list = this.myTable.getAllSettings();
        for (SettingsWrapper settingsWrapper : list) {
            settingsWrapper.reset();
        }
        this.myTable.invalidate();
        this.myTable.repaint();
    }

    private static class NotificationsTableModel
    extends AbstractTableModel {
        private List<SettingsWrapper> mySettings;

        public NotificationsTableModel() {
            NotificationSettings[] settings = NotificationsConfiguration.getAllSettings();
            ArrayList<SettingsWrapper> list = new ArrayList<SettingsWrapper>();
            for (NotificationSettings setting : settings) {
                list.add(new SettingsWrapper(setting));
            }
            this.mySettings = list;
        }

        public List<SettingsWrapper> getSettings() {
            return this.getActiveSettings();
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            NotificationSettings settings = this.getSettings(rowIndex);
            switch (columnIndex) {
                case 1: {
                    settings.setDisplayType((NotificationDisplayType)value);
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.getSettings().size();
        }

        public NotificationSettings getSettings(int row) {
            return this.getSettings().get(row);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (1 == columnIndex) {
                return NotificationDisplayType.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Group";
                }
            }
            return "Display";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.getSettings().get(rowIndex).getGroupId();
                }
            }
            return this.getSettings().get(rowIndex).getDisplayType();
        }

        public static void remove(List<SettingsWrapper> toRemove) {
            for (SettingsWrapper settingsWrapper : toRemove) {
                settingsWrapper.remove();
            }
        }

        public List<SettingsWrapper> getAllSettings() {
            return this.mySettings;
        }

        private List<SettingsWrapper> getActiveSettings() {
            ArrayList<SettingsWrapper> result = new ArrayList<SettingsWrapper>(this.mySettings);
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                SettingsWrapper wrapper = (SettingsWrapper)iterator.next();
                if (!wrapper.isRemoved()) continue;
                iterator.remove();
            }
            return result;
        }
    }

    private static class SettingsWrapper
    extends NotificationSettings {
        private NotificationSettings myOriginal;
        private boolean myRemoved;

        private SettingsWrapper(@NotNull NotificationSettings original) {
            if (original == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsConfigurablePanel$SettingsWrapper.<init> must not be null");
            }
            super(original.getGroupId(), original.getDisplayType());
            this.myRemoved = false;
            this.myOriginal = original;
        }

        public boolean hasChanged() {
            return !this.getDisplayType().equals((Object)this.myOriginal.getDisplayType()) || this.myRemoved;
        }

        public void remove() {
            this.myRemoved = true;
        }

        public boolean isRemoved() {
            return this.myRemoved;
        }

        public void apply() {
            if (this.myRemoved) {
                NotificationsConfiguration.remove(new NotificationSettings[]{this.myOriginal});
            } else if (this.hasChanged()) {
                this.myOriginal.setDisplayType(this.getDisplayType());
            }
        }

        public void reset() {
            if (this.hasChanged()) {
                this.setDisplayType(this.myOriginal.getDisplayType());
                this.myRemoved = false;
            }
        }
    }

    private static class NotificationsTable
    extends StripeTable {
        private static final int ID_COLUMN = 0;
        private static final int DISPLAY_TYPE_COLUMN = 1;

        public NotificationsTable() {
            super((TableModel)new NotificationsTableModel());
            TableColumn idColumn = this.getColumnModel().getColumn(0);
            idColumn.setPreferredWidth(200);
            TableColumn displayTypeColumn = this.getColumnModel().getColumn(1);
            displayTypeColumn.setMaxWidth(300);
            displayTypeColumn.setPreferredWidth(250);
            displayTypeColumn.setCellRenderer((TableCellRenderer)new ComboBoxTableRenderer<NotificationDisplayType>(NotificationDisplayType.values()){

                protected String getTextFor(@NotNull NotificationDisplayType value) {
                    if (value == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTable$1.getTextFor must not be null");
                    }
                    return value.getTitle();
                }
            });
            displayTypeColumn.setCellEditor((TableCellEditor)new ComboBoxTableRenderer<NotificationDisplayType>(NotificationDisplayType.values()){

                public boolean isCellEditable(EventObject event) {
                    if (event instanceof MouseEvent) {
                        return ((MouseEvent)event).getClickCount() >= 1;
                    }
                    return false;
                }

                protected String getTextFor(@NotNull NotificationDisplayType value) {
                    if (value == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTable$2.getTextFor must not be null");
                    }
                    return value.getTitle();
                }
            });
        }

        public Dimension getMinimumSize() {
            return this.calcSize(super.getMinimumSize());
        }

        public Dimension getPreferredSize() {
            return this.calcSize(super.getPreferredSize());
        }

        private Dimension calcSize(@NotNull Dimension s) {
            if (s == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTable.calcSize must not be null");
            }
            Container container = this.getParent();
            if (container != null) {
                Dimension size = container.getSize();
                return new Dimension(size.width, s.height);
            }
            return s;
        }

        public List<SettingsWrapper> getSettings() {
            return ((NotificationsTableModel)this.getModel()).getSettings();
        }

        public void removeSelected() {
            ListSelectionModel selectionModel = this.getSelectionModel();
            if (!selectionModel.isSelectionEmpty()) {
                int min = selectionModel.getMinSelectionIndex();
                int max = selectionModel.getMaxSelectionIndex();
                List<SettingsWrapper> settings = this.getSettings();
                ArrayList<SettingsWrapper> toRemove = new ArrayList<SettingsWrapper>();
                for (int i = min; i <= max && i < settings.size(); ++i) {
                    toRemove.add(settings.get(i));
                }
                if (toRemove.size() > 0) {
                    NotificationsTableModel cfr_ignored_0 = (NotificationsTableModel)this.getModel();
                    NotificationsTableModel.remove(toRemove);
                    this.revalidate();
                    this.repaint();
                }
            }
        }

        public List<SettingsWrapper> getAllSettings() {
            return ((NotificationsTableModel)this.getModel()).getAllSettings();
        }
    }
}

