/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.impl.NotificationsConfiguration;
import com.intellij.notification.impl.ui.NotificationsConfigurablePanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;

public class NotificationsConfigurable
implements Configurable,
SearchableConfigurable,
OptionalConfigurable {
    public static final String DISPLAY_NAME = "Notifications";
    private NotificationsConfigurablePanel myComponent;

    public static NotificationsConfigurable getNotificationsConfigurable() {
        return (NotificationsConfigurable)ShowSettingsUtil.getInstance().findApplicationConfigurable(NotificationsConfigurable.class);
    }

    public static void editSettings() {
        NotificationsConfigurable configurable = NotificationsConfigurable.getNotificationsConfigurable();
        ShowSettingsUtil.getInstance().editConfigurable((Project)null, (Configurable)configurable);
    }

    @Nls
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.settings.ide.settings.notifications";
    }

    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = new NotificationsConfigurablePanel();
        }
        return this.myComponent;
    }

    public boolean isModified() {
        return this.myComponent != null && this.myComponent.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myComponent.apply();
    }

    public void reset() {
        this.myComponent.reset();
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myComponent);
        this.myComponent = null;
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public boolean needDisplay() {
        return NotificationsConfiguration.getAllSettings().length > 0;
    }
}

