/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.ide.util.scopeChooser.ScopeEditorPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.packageDependencies.DefaultScopesProvider;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.ComboboxWithBrowseButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class PackageSetChooserCombo
extends ComboboxWithBrowseButton {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)("#" + PackageSetChooserCombo.class.getName()));

    public PackageSetChooserCombo(Project project, String preselect) {
        this(project, preselect, true);
    }

    public PackageSetChooserCombo(Project project, String preselect, boolean enableBrowseButton) {
        final JComboBox combo = this.getComboBox();
        combo.setBorder(null);
        this.myProject = project;
        if (enableBrowseButton) {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final NamedScope scope = (NamedScope)combo.getSelectedItem();
                    if (scope instanceof NamedScope.UnnamedScope) {
                        Map unnamedScoopes = DependencyValidationManager.getInstance((Project)PackageSetChooserCombo.this.myProject).getUnnamedScopes();
                        EditUnnamedScopesDialog dlg = new EditUnnamedScopesDialog(scope);
                        dlg.show();
                        if (dlg.isOK()) {
                            PackageSet packageSet = scope.getValue();
                            LOG.assertTrue(packageSet != null);
                            unnamedScoopes.remove(packageSet.getText());
                            PackageSet editedScope = dlg.getScope();
                            if (editedScope != null) {
                                unnamedScoopes.put(editedScope.getText(), editedScope);
                            }
                            PackageSetChooserCombo.this.rebuild();
                            if (editedScope != null) {
                                PackageSetChooserCombo.this.selectScope(editedScope.getText());
                            }
                        }
                    } else {
                        final ScopeChooserConfigurable configurable = ScopeChooserConfigurable.getInstance(PackageSetChooserCombo.this.myProject);
                        EditScopesDialog dlg = EditScopesDialog.editConfigurable(PackageSetChooserCombo.this.myProject, new Runnable(){

                            @Override
                            public void run() {
                                configurable.selectNodeInTree(scope.getName());
                            }
                        }, true);
                        if (dlg.isOK()) {
                            PackageSetChooserCombo.this.rebuild();
                            NamedScope namedScope = dlg.getSelectedScope();
                            if (namedScope != null) {
                                PackageSetChooserCombo.this.selectScope(namedScope.getName());
                            }
                        }
                    }
                }
            });
        } else {
            this.getButton().setVisible(false);
        }
        combo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(value == null ? "" : ((NamedScope)value).getName());
                return this;
            }
        });
        this.rebuild();
        this.selectScope(preselect);
    }

    private void selectScope(String preselect) {
        JComboBox combo = this.getComboBox();
        if (preselect != null) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                NamedScope descriptor = (NamedScope)model.getElementAt(i);
                if (!preselect.equals(descriptor.getName())) continue;
                combo.setSelectedIndex(i);
                break;
            }
        }
    }

    private void rebuild() {
        this.getComboBox().setModel(this.createModel());
    }

    private DefaultComboBoxModel createModel() {
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)this.myProject);
        DefaultComboBoxModel<NamedScope> model = new DefaultComboBoxModel<NamedScope>(manager.getScopes());
        Map unnamedScopes = manager.getUnnamedScopes();
        for (PackageSet unnamedScope : unnamedScopes.values()) {
            model.addElement((NamedScope)new NamedScope.UnnamedScope(unnamedScope));
        }
        model.removeElement(DefaultScopesProvider.getInstance(this.myProject).getProblemsScope());
        return model;
    }

    @Nullable
    public NamedScope getSelectedScope() {
        JComboBox combo = this.getComboBox();
        int idx = combo.getSelectedIndex();
        if (idx < 0) {
            return null;
        }
        return (NamedScope)combo.getSelectedItem();
    }

    private class EditUnnamedScopesDialog
    extends DialogWrapper {
        private PackageSet myScope;
        private final ScopeEditorPanel myPanel;

        public EditUnnamedScopesDialog(NamedScope scope) {
            super((Component)((Object)PackageSetChooserCombo.this), false);
            this.myScope = scope.getValue();
            this.myPanel = new ScopeEditorPanel(PackageSetChooserCombo.this.myProject, (NamedScopesHolder)DependencyValidationManager.getInstance((Project)PackageSetChooserCombo.this.myProject));
            this.init();
            this.myPanel.reset(this.myScope, null);
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myPanel.getPanel();
        }

        protected void doOKAction() {
            this.myScope = this.myPanel.getCurrentScope();
            super.doOKAction();
        }

        public PackageSet getScope() {
            return this.myScope;
        }
    }
}

