/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.todo.HighlightedRegionProvider;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.SmartTodoItemPointerComparator;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.TodoItem;
import com.intellij.ui.HighlightedRegion;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class TodoFileNode
extends PsiFileNode
implements HighlightedRegionProvider {
    private final TodoTreeBuilder myBuilder;
    private final ArrayList<HighlightedRegion> myHighlightedRegions;
    private final boolean mySingleFileMode;

    public TodoFileNode(Project project, PsiFile file, TodoTreeBuilder treeBuilder, boolean singleFileMode) {
        super(project, file, ViewSettings.DEFAULT);
        this.myBuilder = treeBuilder;
        this.myHighlightedRegions = new ArrayList(2);
        this.mySingleFileMode = singleFileMode;
    }

    public ArrayList<HighlightedRegion> getHighlightedRegions() {
        return this.myHighlightedRegions;
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        if (!this.mySingleFileMode) {
            return this.createGeneralList();
        }
        return this.createListForSingleFile();
    }

    private Collection<AbstractTreeNode> createListForSingleFile() {
        TodoItem[] items = this.myBuilder.getTodoTreeStructure().getSearchHelper().findTodoItems((PsiFile)this.getValue());
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>(items.length);
        for (TodoItem todoItem : items) {
            Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument((PsiFile)this.getValue());
            if (document == null || todoItem.getTextRange().getEndOffset() >= document.getTextLength() + 1) continue;
            SmartTodoItemPointer pointer = new SmartTodoItemPointer(todoItem, document);
            TodoFilter toDoFilter = this.getToDoFilter();
            if (toDoFilter != null) {
                TodoItemNode itemNode = new TodoItemNode(this.getProject(), pointer, this.myBuilder);
                if (!toDoFilter.contains(todoItem.getPattern())) continue;
                children.add(itemNode);
                continue;
            }
            children.add(new TodoItemNode(this.getProject(), pointer, this.myBuilder));
        }
        Collections.sort(children, SmartTodoItemPointerComparator.ourInstance);
        return children;
    }

    private Collection<AbstractTreeNode> createGeneralList() {
        TodoItem[] items;
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        PsiFile psiFile = (PsiFile)this.getValue();
        for (TodoItem todoItem : items = this.myBuilder.getTodoTreeStructure().getSearchHelper().findTodoItems(psiFile)) {
            Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
            if (document == null || todoItem.getTextRange().getEndOffset() >= document.getTextLength() + 1) continue;
            SmartTodoItemPointer pointer = new SmartTodoItemPointer(todoItem, document);
            TodoFilter todoFilter = this.getToDoFilter();
            if (todoFilter != null) {
                if (!todoFilter.contains(todoItem.getPattern())) continue;
                children.add(new TodoItemNode(this.getProject(), pointer, this.myBuilder));
                continue;
            }
            children.add(new TodoItemNode(this.getProject(), pointer, this.myBuilder));
        }
        Collections.sort(children, SmartTodoItemPointerComparator.ourInstance);
        return children;
    }

    private TodoFilter getToDoFilter() {
        return this.myBuilder.getTodoTreeStructure().getTodoFilter();
    }

    @Override
    protected void updateImpl(PresentationData data) {
        super.updateImpl(data);
        String newName = this.myBuilder.getTodoTreeStructure().isPackagesShown() ? ((PsiFile)this.getValue()).getName() : (this.mySingleFileMode ? ((PsiFile)this.getValue()).getName() : ((PsiFile)this.getValue()).getVirtualFile().getPresentableUrl());
        int nameEndOffset = newName.length();
        int todoItemCount = this.myBuilder.getTodoTreeStructure().getTodoItemCount((PsiFile)this.getValue());
        newName = this.mySingleFileMode ? (todoItemCount == 0 ? IdeBundle.message((String)"node.todo.no.items.found", (Object[])new Object[]{newName}) : IdeBundle.message((String)"node.todo.found.items", (Object[])new Object[]{newName, todoItemCount})) : IdeBundle.message((String)"node.todo.items", (Object[])new Object[]{newName, todoItemCount});
        this.myHighlightedRegions.clear();
        TextAttributes textAttributes = new TextAttributes();
        textAttributes.setForegroundColor(this.myColor);
        this.myHighlightedRegions.add(new HighlightedRegion(0, nameEndOffset, textAttributes));
        EditorColorsScheme colorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
        this.myHighlightedRegions.add(new HighlightedRegion(nameEndOffset, newName.length(), colorsScheme.getAttributes(UsageTreeColors.NUMBER_OF_USAGES)));
    }

    @Override
    public int getWeight() {
        return 4;
    }
}

