/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

class TodoPanelSettings {
    private boolean myArePackagesShown;
    private boolean myAreModulesShown;
    private boolean myAreFlattenPackages;
    private boolean myIsAutoScrollToSource;
    private String myTodoFilterName;
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    private static final String ELEMENT_ARE_PACKAGES_SHOWN = "are-packages-shown";
    @NonNls
    private static final String ELEMENT_ARE_MODULES_SHOWN = "are-modules-shown";
    @NonNls
    private static final String ELEMENT_FLATTEN_PACKAGES = "flatten-packages";
    @NonNls
    private static final String ELEMENT_AUTOSCROLL_TO_SOURCE = "is-autoscroll-to-source";
    @NonNls
    private static final String ELEMENT_TODO_FILTER = "todo-filter";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";

    TodoPanelSettings() {
    }

    public void readExternal(Element e) {
        for (Element child : e.getChildren()) {
            if (ELEMENT_ARE_PACKAGES_SHOWN.equals(child.getName())) {
                this.myArePackagesShown = Boolean.valueOf(child.getAttributeValue(ATTRIBUTE_VALUE));
                continue;
            }
            if (ELEMENT_ARE_MODULES_SHOWN.equals(child.getName())) {
                this.myAreModulesShown = Boolean.valueOf(child.getAttributeValue(ATTRIBUTE_VALUE));
                continue;
            }
            if (ELEMENT_FLATTEN_PACKAGES.equals(child.getName())) {
                this.myAreFlattenPackages = Boolean.valueOf(child.getAttributeValue(ATTRIBUTE_VALUE));
                continue;
            }
            if (ELEMENT_AUTOSCROLL_TO_SOURCE.equals(child.getName())) {
                this.myIsAutoScrollToSource = Boolean.valueOf(child.getAttributeValue(ATTRIBUTE_VALUE));
                continue;
            }
            if (!ELEMENT_TODO_FILTER.equals(child.getName())) continue;
            this.myTodoFilterName = child.getAttributeValue(ATTRIBUTE_NAME);
        }
    }

    public void writeExternal(Element e) {
        Element areArePackagesShownElement = new Element(ELEMENT_ARE_PACKAGES_SHOWN);
        areArePackagesShownElement.setAttribute(ATTRIBUTE_VALUE, this.myArePackagesShown ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        e.addContent(areArePackagesShownElement);
        Element areModulesShownElement = new Element(ELEMENT_ARE_MODULES_SHOWN);
        areModulesShownElement.setAttribute(ATTRIBUTE_VALUE, this.myAreModulesShown ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        e.addContent(areModulesShownElement);
        Element areAreFlattenPackagesElement = new Element(ELEMENT_FLATTEN_PACKAGES);
        areAreFlattenPackagesElement.setAttribute(ATTRIBUTE_VALUE, this.myAreFlattenPackages ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        e.addContent(areAreFlattenPackagesElement);
        Element isAutoScrollModeElement = new Element(ELEMENT_AUTOSCROLL_TO_SOURCE);
        isAutoScrollModeElement.setAttribute(ATTRIBUTE_VALUE, this.myIsAutoScrollToSource ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        e.addContent(isAutoScrollModeElement);
        if (this.myTodoFilterName != null) {
            Element todoFilterElement = new Element(ELEMENT_TODO_FILTER);
            todoFilterElement.setAttribute(ATTRIBUTE_NAME, this.myTodoFilterName);
            e.addContent(todoFilterElement);
        }
    }

    boolean areModulesShown() {
        return this.myAreModulesShown;
    }

    public void setShownModules(boolean state) {
        this.myAreModulesShown = state;
    }

    boolean arePackagesShown() {
        return this.myArePackagesShown;
    }

    public void setShownPackages(boolean state) {
        this.myArePackagesShown = state;
    }

    boolean areFlattenPackages() {
        return this.myAreFlattenPackages;
    }

    void setAreFlattenPackages(boolean state) {
        this.myAreFlattenPackages = state;
    }

    boolean isAutoScrollToSource() {
        return this.myIsAutoScrollToSource;
    }

    void setAutoScrollToSource(boolean state) {
        this.myIsAutoScrollToSource = state;
    }

    String getTodoFilterName() {
        return this.myTodoFilterName;
    }

    void setTodoFilterName(String todoFilterName) {
        this.myTodoFilterName = todoFilterName;
    }
}

