/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.DefaultCreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.DefaultTemplatePropertiesProvider;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTemplateUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.FileTemplateUtil");
    private static boolean ourVelocityInitialized = false;
    private static final CreateFromTemplateHandler ourDefaultCreateFromTemplateHandler = new DefaultCreateFromTemplateHandler();
    @NonNls
    private static final String INCLUDES_PATH = "fileTemplates/includes/";

    private FileTemplateUtil() {
    }

    public static String[] calculateAttributes(String templateContent, Properties properties, boolean includeDummies) throws ParseException {
        FileTemplateUtil.initVelocity();
        HashSet<String> unsetAttributes = new HashSet<String>();
        FileTemplateUtil.addAttributesToVector(unsetAttributes, (Node)RuntimeSingleton.parse((Reader)new StringReader(templateContent), (String)"MyTemplate"), properties, includeDummies);
        return ArrayUtil.toStringArray(unsetAttributes);
    }

    private static void addAttributesToVector(Set<String> references, Node apacheNode, Properties properties, boolean includeDummies) {
        int childCount = apacheNode.jjtGetNumChildren();
        for (int i = 0; i < childCount; ++i) {
            Node apacheChild = apacheNode.jjtGetChild(i);
            FileTemplateUtil.addAttributesToVector(references, apacheChild, properties, includeDummies);
            if (!(apacheChild instanceof ASTReference)) continue;
            ASTReference apacheReference = (ASTReference)apacheChild;
            String s = apacheReference.literal();
            if ((s = FileTemplateUtil.referenceToAttribute(s, includeDummies)) == null || s.length() <= 0 || properties.getProperty(s) != null) continue;
            references.add(s);
        }
    }

    @Nullable
    private static String referenceToAttribute(String attrib, boolean includeDummies) {
        while (attrib.startsWith("\\\\")) {
            attrib = attrib.substring(2);
        }
        if (attrib.startsWith("\\$")) {
            if (includeDummies) {
                attrib = attrib.substring(1);
            } else {
                return null;
            }
        }
        if (!StringUtil.startsWithChar((CharSequence)attrib, (char)'$')) {
            return null;
        }
        if (StringUtil.startsWithChar((CharSequence)(attrib = attrib.substring(1)), (char)'{')) {
            String cleanAttribute = null;
            for (int i = 1; i < attrib.length(); ++i) {
                char currChar = attrib.charAt(i);
                if (currChar == '{' || currChar == '.') {
                    cleanAttribute = null;
                    break;
                }
                if (currChar != '}') continue;
                cleanAttribute = attrib.substring(1, i);
                break;
            }
            attrib = cleanAttribute;
        } else {
            for (int i = 0; i < attrib.length(); ++i) {
                char currChar = attrib.charAt(i);
                if (currChar != '{' && currChar != '}' && currChar != '.') continue;
                attrib = attrib.substring(0, i);
                break;
            }
        }
        return attrib;
    }

    public static String mergeTemplate(Map attributes, String content) throws IOException {
        FileTemplateUtil.initVelocity();
        VelocityContext context = new VelocityContext();
        for (Object o : attributes.keySet()) {
            String name = (String)o;
            context.put(name, attributes.get(name));
        }
        return FileTemplateUtil.mergeTemplate(content, context);
    }

    public static String mergeTemplate(Properties attributes, String content) throws IOException {
        FileTemplateUtil.initVelocity();
        VelocityContext context = new VelocityContext();
        Enumeration<?> names = attributes.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            context.put(name, (Object)attributes.getProperty(name));
        }
        return FileTemplateUtil.mergeTemplate(content, context);
    }

    private static String mergeTemplate(String templateContent, VelocityContext context) throws IOException {
        FileTemplateUtil.initVelocity();
        StringWriter stringWriter = new StringWriter();
        try {
            Velocity.evaluate((Context)context, (Writer)stringWriter, (String)"", (String)templateContent);
        }
        catch (VelocityException e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((String)IdeBundle.message((String)"error.parsing.file.template", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.velocity.error", (Object[])new Object[0]));
                }
            });
        }
        return stringWriter.toString();
    }

    public static FileTemplate cloneTemplate(FileTemplate template) {
        FileTemplateImpl templateImpl = (FileTemplateImpl)template;
        return (FileTemplate)templateImpl.clone();
    }

    public static void copyTemplate(FileTemplate src, FileTemplate dest) {
        dest.setExtension(src.getExtension());
        dest.setName(src.getName());
        dest.setText(src.getText());
        dest.setAdjust(src.isAdjust());
    }

    private static synchronized void initVelocity() {
        try {
            if (ourVelocityInitialized) {
                return;
            }
            File modifiedPatternsPath = new File(PathManager.getConfigPath());
            modifiedPatternsPath = new File(modifiedPatternsPath, "fileTemplates");
            modifiedPatternsPath = new File(modifiedPatternsPath, "includes");
            LogSystem emptyLogSystem = new LogSystem(){

                public void init(RuntimeServices runtimeServices) throws Exception {
                }

                public void logVelocityMessage(int i, String s) {
                }
            };
            Velocity.setProperty((String)"runtime.log.logsystem", (Object)emptyLogSystem);
            Velocity.setProperty((String)"resource.loader", (Object)"file,class");
            Velocity.setProperty((String)"file.resource.loader.class", (Object)MyFileResourceLoader.class.getName());
            Velocity.setProperty((String)"class.resource.loader.class", (Object)MyClasspathResourceLoader.class.getName());
            Velocity.setProperty((String)"file.resource.loader.path", (Object)modifiedPatternsPath.getAbsolutePath());
            Velocity.setProperty((String)"input.encoding", (Object)"UTF-8");
            Velocity.init();
            ourVelocityInitialized = true;
        }
        catch (Exception e) {
            LOG.error("Unable to init Velocity", (Throwable)e);
        }
    }

    public static PsiElement createFromTemplate(final @NotNull FileTemplate template, final @NonNls @Nullable String fileName, @Nullable Properties props, final @NotNull PsiDirectory directory) throws Exception {
        String packageName;
        String[] dummyRefs;
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/FileTemplateUtil.createFromTemplate must not be null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/ide/fileTemplates/FileTemplateUtil.createFromTemplate must not be null");
        }
        final Project project = directory.getProject();
        if (props == null) {
            props = FileTemplateManager.getInstance().getDefaultProperties();
        }
        FileTemplateManager.getInstance().addRecentName(template.getName());
        FileTemplateUtil.fillDefaultProperties(props, directory);
        if (fileName != null && props.getProperty("NAME") == null) {
            props.setProperty("NAME", fileName);
        }
        for (String dummyRef : dummyRefs = FileTemplateUtil.calculateAttributes(template.getText(), props, true)) {
            props.setProperty(dummyRef, "");
        }
        if (template.isJavaClassTemplate() && ((packageName = props.getProperty("PACKAGE_NAME")) == null || packageName.length() == 0)) {
            props = new Properties(props);
            props.setProperty("PACKAGE_NAME", "PACKAGE_NAME");
        }
        String mergedText = template.getText(props);
        final String templateText = StringUtil.convertLineSeparators((String)mergedText);
        final Exception[] commandException = new Exception[1];
        final PsiElement[] result = new PsiElement[1];
        final Properties finalProps = props;
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CreateFromTemplateHandler handler = FileTemplateUtil.findHandler(template);
                            result[0] = handler.createFromTemplate(project, directory, fileName, template, templateText, finalProps);
                        }
                        catch (Exception ex) {
                            commandException[0] = ex;
                        }
                    }
                };
                ApplicationManager.getApplication().runWriteAction(run);
            }
        }, template.isJavaClassTemplate() ? IdeBundle.message((String)"command.create.class.from.template", (Object[])new Object[0]) : IdeBundle.message((String)"command.create.file.from.template", (Object[])new Object[0]), null);
        if (commandException[0] != null) {
            throw commandException[0];
        }
        return result[0];
    }

    private static CreateFromTemplateHandler findHandler(FileTemplate template) {
        for (CreateFromTemplateHandler handler : (CreateFromTemplateHandler[])Extensions.getExtensions(CreateFromTemplateHandler.EP_NAME)) {
            if (!handler.handlesTemplate(template)) continue;
            return handler;
        }
        return ourDefaultCreateFromTemplateHandler;
    }

    public static void fillDefaultProperties(Properties props, PsiDirectory directory) {
        DefaultTemplatePropertiesProvider[] providers;
        for (DefaultTemplatePropertiesProvider provider : providers = (DefaultTemplatePropertiesProvider[])Extensions.getExtensions((ExtensionPointName)DefaultTemplatePropertiesProvider.EP_NAME)) {
            provider.fillProperties(directory, props);
        }
    }

    public static String indent(String methodText, Project project, FileType fileType) {
        int indent = CodeStyleSettingsManager.getSettings((Project)project).getIndentSize(fileType);
        return methodText.replaceAll("\n", "\n" + StringUtil.repeatSymbol((char)' ', (int)indent));
    }

    public static boolean canCreateFromTemplate(PsiDirectory[] dirs, FileTemplate template) {
        FileType fileType = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(template.getExtension());
        if (fileType.equals(FileTypes.UNKNOWN)) {
            return false;
        }
        CreateFromTemplateHandler handler = FileTemplateUtil.findHandler(template);
        return handler.canCreate(dirs);
    }

    public static class MyFileResourceLoader
    extends FileResourceLoader {
        public void init(ExtendedProperties configuration) {
            super.init(configuration);
            File modifiedPatternsPath = new File(PathManager.getConfigPath());
            modifiedPatternsPath = new File(modifiedPatternsPath, FileTemplateUtil.INCLUDES_PATH);
            try {
                Field pathsField = FileResourceLoader.class.getDeclaredField("paths");
                pathsField.setAccessible(true);
                Collection paths = (Collection)pathsField.get((Object)this);
                paths.clear();
                paths.add(modifiedPatternsPath.getAbsolutePath());
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    File file1 = new File(PathManagerEx.getTestDataPath());
                    File testsDir = new File(new File(file1, "ide"), "fileTemplates");
                    paths.add(testsDir.getAbsolutePath());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class MyClasspathResourceLoader
    extends ClasspathResourceLoader {
        @NonNls
        private static final String FT_EXTENSION = ".ft";

        public synchronized InputStream getResourceStream(String name) throws ResourceNotFoundException {
            return super.getResourceStream(FileTemplateUtil.INCLUDES_PATH + name + FT_EXTENSION);
        }
    }
}

