/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionMacro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actionMacro.ActionMacro;
import com.intellij.ide.actionMacro.ActionMacroManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ListUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.HashSet;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ActionMacroConfigurationPanel {
    private JPanel myPanel;
    private JButton myDeleteButton;
    private JButton myRenameButton;
    private JButton myExcludeActionButton;
    private JList myMacrosList;
    private JList myMacroActionsList;
    final DefaultListModel myMacrosModel;

    public ActionMacroConfigurationPanel() {
        this.$$$setupUI$$$();
        this.myMacrosModel = new DefaultListModel();
        ListUtil.addRemoveListener((JButton)this.myDeleteButton, (JList)this.myMacrosList);
        this.myMacrosList.setSelectionMode(0);
        this.myMacroActionsList.setSelectionMode(0);
        this.myRenameButton.setEnabled(false);
        this.myDeleteButton.setEnabled(false);
        this.myExcludeActionButton.setEnabled(false);
        this.myMacrosList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selIndex = ActionMacroConfigurationPanel.this.myMacrosList.getSelectedIndex();
                if (selIndex == -1) {
                    ((DefaultListModel)ActionMacroConfigurationPanel.this.myMacroActionsList.getModel()).removeAllElements();
                    ActionMacroConfigurationPanel.this.myExcludeActionButton.setEnabled(false);
                    ActionMacroConfigurationPanel.this.myRenameButton.setEnabled(false);
                } else {
                    ActionMacroConfigurationPanel.this.myRenameButton.setEnabled(true);
                    ActionMacroConfigurationPanel.this.initActionList((ActionMacro)ActionMacroConfigurationPanel.this.myMacrosModel.getElementAt(selIndex));
                }
            }
        });
        this.myMacroActionsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selIdx = ActionMacroConfigurationPanel.this.myMacroActionsList.getSelectedIndex();
                ActionMacroConfigurationPanel.this.myExcludeActionButton.setEnabled(selIdx != -1);
            }
        });
        this.myExcludeActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selIndex = ActionMacroConfigurationPanel.this.myMacrosList.getSelectedIndex();
                if (selIndex != -1) {
                    ActionMacro macro = (ActionMacro)ActionMacroConfigurationPanel.this.myMacrosModel.getElementAt(selIndex);
                    macro.deleteAction(ActionMacroConfigurationPanel.this.myMacroActionsList.getSelectedIndex());
                }
                ListUtil.removeSelectedItems((JList)ActionMacroConfigurationPanel.this.myMacroActionsList);
            }
        });
        this.myRenameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selIndex = ActionMacroConfigurationPanel.this.myMacrosList.getSelectedIndex();
                if (selIndex == -1) {
                    return;
                }
                ActionMacro macro = (ActionMacro)ActionMacroConfigurationPanel.this.myMacrosModel.getElementAt(selIndex);
                String newName = Messages.showInputDialog((Component)ActionMacroConfigurationPanel.this.myPanel, (String)IdeBundle.message((String)"prompt.enter.new.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.macro", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)macro.getName(), null);
                if (newName != null) {
                    macro.setName(newName);
                    ActionMacroConfigurationPanel.this.myMacrosList.repaint();
                }
            }
        });
    }

    public void reset() {
        ActionMacro[] allMacros;
        for (ActionMacro macro : allMacros = ActionMacroManager.getInstance().getAllMacros()) {
            this.myMacrosModel.addElement(macro.clone());
        }
        this.myMacrosList.setModel(this.myMacrosModel);
        ListScrollingUtil.ensureSelectionExists((JList)this.myMacrosList);
    }

    public void apply() {
        ActionMacroManager manager = ActionMacroManager.getInstance();
        ActionMacro[] macros = manager.getAllMacros();
        HashSet removedIds = new HashSet();
        for (ActionMacro macro1 : macros) {
            removedIds.add((Object)macro1.getActionId());
        }
        manager.removeAllMacros();
        Enumeration newMacros = this.myMacrosModel.elements();
        while (newMacros.hasMoreElements()) {
            ActionMacro macro = (ActionMacro)newMacros.nextElement();
            manager.addMacro(macro);
            removedIds.remove((Object)macro.getActionId());
        }
        manager.registerActions();
        for (String id : removedIds) {
            Keymap[] allKeymaps;
            for (Keymap keymap : allKeymaps = KeymapManagerEx.getInstanceEx().getAllKeymaps()) {
                keymap.removeAllActionShortcuts(id);
            }
        }
    }

    public boolean isModified() {
        ActionMacro[] allMacros = ActionMacroManager.getInstance().getAllMacros();
        if (allMacros.length != this.myMacrosModel.getSize()) {
            return true;
        }
        for (int i = 0; i < allMacros.length; ++i) {
            ActionMacro macro = allMacros[i];
            ActionMacro newMacro = (ActionMacro)this.myMacrosModel.get(i);
            if (macro.equals(newMacro)) continue;
            return true;
        }
        return false;
    }

    private void initActionList(ActionMacro macro) {
        ActionMacro.ActionDescriptor[] actions;
        DefaultListModel<ActionMacro.ActionDescriptor> actionModel = new DefaultListModel<ActionMacro.ActionDescriptor>();
        for (ActionMacro.ActionDescriptor action : actions = macro.getActions()) {
            actionModel.addElement(action);
        }
        this.myMacroActionsList.setModel(actionModel);
        ListScrollingUtil.ensureSelectionExists((JList)this.myMacroActionsList);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JList jList;
        JList jList2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 2, 1, 0, 3, 7, 7, null, null, null));
        this.myMacrosList = jList2 = new JList();
        jScrollPane.setViewportView(jList2);
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel.add((Component)jScrollPane2, new GridConstraints(2, 0, 2, 1, 0, 3, 7, 7, null, null, null));
        this.myMacroActionsList = jList = new JList();
        jScrollPane2.setViewportView(jList);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeleteButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/IdeBundle").getString("button.delete"));
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRenameButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/IdeBundle").getString("button.rename"));
        jButton2.setLabel(ResourceBundle.getBundle("messages/IdeBundle").getString("button.rename"));
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExcludeActionButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/IdeBundle").getString("button.remove.action"));
        jPanel3.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

