/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Block;
import com.intellij.formatting.WhiteSpace;
import com.intellij.openapi.util.TextRange;
import java.util.List;

public class CompositeBlockWrapper
extends AbstractBlockWrapper {
    private List<AbstractBlockWrapper> myChildren;

    public CompositeBlockWrapper(Block block, WhiteSpace whiteSpace, CompositeBlockWrapper parent, TextRange textRange) {
        super(block, whiteSpace, parent, textRange);
    }

    public List<AbstractBlockWrapper> getChildren() {
        return this.myChildren;
    }

    public void setChildren(List<AbstractBlockWrapper> children) {
        this.myChildren = children;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.myChildren != null) {
            for (AbstractBlockWrapper wrapper : this.myChildren) {
                wrapper.reset();
            }
        }
    }

    @Override
    protected boolean indentAlreadyUsedBefore(AbstractBlockWrapper child) {
        for (AbstractBlockWrapper childBefore : this.myChildren) {
            if (childBefore == child) {
                return false;
            }
            if (!childBefore.getWhiteSpace().containsLineFeeds()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myChildren = null;
    }

    public AbstractBlockWrapper getPrevIndentedSibling(AbstractBlockWrapper current) {
        AbstractBlockWrapper candidate = null;
        for (AbstractBlockWrapper child : this.myChildren) {
            if (child.getStartOffset() >= current.getStartOffset()) {
                return candidate;
            }
            if (!child.getWhiteSpace().containsLineFeeds()) continue;
            candidate = child;
        }
        return candidate;
    }
}

