/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.usageView.UsageViewManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFindUsagesDialog
extends DialogWrapper {
    private final Project myProject;
    protected final FindUsagesOptions myFindUsagesOptions;
    private final boolean myToShowInNewTab;
    private final boolean myIsShowInNewTabEnabled;
    private final boolean myIsShowInNewTabVisible;
    private final boolean mySearchForTextOccurencesAvailable;
    private final boolean mySearchInLibrariesAvailable;
    private JCheckBox myCbToOpenInNewTab;
    protected StateRestoringCheckBox myCbToSearchForTextOccurences;
    protected JCheckBox myCbToSkipResultsWhenOneUsage;
    private final ActionListener myUpdateAction;
    private ScopeChooserCombo myScopeCombo;

    protected AbstractFindUsagesDialog(@NotNull Project project, @NotNull FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, boolean searchForTextOccurencesAvailable, boolean searchInLibrariesAvailable) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/AbstractFindUsagesDialog.<init> must not be null");
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/findUsages/AbstractFindUsagesDialog.<init> must not be null");
        }
        super(project, true);
        this.myProject = project;
        this.myFindUsagesOptions = findUsagesOptions;
        this.myToShowInNewTab = toShowInNewTab;
        this.myIsShowInNewTabEnabled = !mustOpenInNewTab && UsageViewManager.getInstance((Project)this.myProject).getReusableContentsCount() > 0;
        this.myIsShowInNewTabVisible = !isSingleFile;
        this.mySearchForTextOccurencesAvailable = searchForTextOccurencesAvailable;
        this.mySearchInLibrariesAvailable = searchInLibrariesAvailable;
        this.myUpdateAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractFindUsagesDialog.this.update();
            }
        };
        this.setButtonsMargin(null);
        this.setOKButtonText(FindBundle.message("find.dialog.find.button", new Object[0]));
        this.setOKButtonIcon(IconLoader.getIcon((String)"/actions/find.png"));
        this.setTitle(isSingleFile ? FindBundle.message("find.usages.in.file.dialog.title", new Object[0]) : FindBundle.message("find.usages.dialog.title", new Object[0]));
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected boolean isInFileOnly() {
        return !this.myIsShowInNewTabVisible;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 4, 4, 4);
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.anchor = 13;
        JLabel promptLabel = new JLabel(this.getLabelText());
        panel.add((Component)promptLabel, gbConstraints);
        return panel;
    }

    public abstract String getLabelText();

    protected JComponent createCenterPanel() {
        JPanel allOptionsPanel;
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        panel.add((Component)_panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.myIsShowInNewTabVisible) {
            this.myCbToOpenInNewTab = new JCheckBox(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0]));
            this.myCbToOpenInNewTab.setSelected(this.myToShowInNewTab);
            this.myCbToOpenInNewTab.setEnabled(this.myIsShowInNewTabEnabled);
            _panel.add((Component)this.myCbToOpenInNewTab, "East");
        }
        if ((allOptionsPanel = this.createAllOptionsPanel()) != null) {
            panel.add((Component)allOptionsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    public final FindUsagesOptions calcFindUsagesOptions() {
        this.calcFindUsagesOptions(this.myFindUsagesOptions);
        return this.myFindUsagesOptions;
    }

    protected void init() {
        super.init();
        this.update();
    }

    public void calcFindUsagesOptions(FindUsagesOptions options) {
        options.searchScope = this.myScopeCombo == null ? GlobalSearchScope.allScope((Project)this.myProject) : this.myScopeCombo.getSelectedScope();
        options.isSearchForTextOccurences = AbstractFindUsagesDialog.isToChange(this.myCbToSearchForTextOccurences) && AbstractFindUsagesDialog.isSelected(this.myCbToSearchForTextOccurences);
    }

    protected void update() {
    }

    public boolean isShowInSeparateWindow() {
        return this.myCbToOpenInNewTab != null && this.myCbToOpenInNewTab.isSelected();
    }

    public boolean isSkipResultsWhenOneUsage() {
        return this.myCbToSkipResultsWhenOneUsage != null && this.myCbToSkipResultsWhenOneUsage.isSelected();
    }

    protected void doOKAction() {
        if (!this.shouldDoOkAction()) {
            return;
        }
        FindSettings settings = FindSettings.getInstance();
        if (this.myScopeCombo != null) {
            settings.setDefaultScopeName(this.myScopeCombo.getSelectedScopeName());
        }
        if (this.mySearchForTextOccurencesAvailable && this.myCbToSearchForTextOccurences != null && this.myCbToSearchForTextOccurences.isEnabled()) {
            settings.setSearchForTextOccurences(this.myCbToSearchForTextOccurences.isSelected());
        }
        if (this.myCbToSkipResultsWhenOneUsage != null) {
            settings.setSkipResultsWithOneUsage(this.isSkipResultsWhenOneUsage());
        }
        super.doOKAction();
    }

    protected boolean shouldDoOkAction() {
        return this.myScopeCombo == null || this.myScopeCombo.getSelectedScope() != null;
    }

    protected static boolean isToChange(JCheckBox cb) {
        return cb != null && cb.getParent() != null;
    }

    protected static boolean isSelected(JCheckBox cb) {
        return cb != null && cb.getParent() != null && cb.isSelected();
    }

    protected StateRestoringCheckBox addCheckboxToPanel(String name, boolean toSelect, JPanel panel, boolean toUpdate) {
        StateRestoringCheckBox cb = new StateRestoringCheckBox(name);
        cb.setSelected(toSelect);
        panel.add(cb);
        if (toUpdate) {
            cb.addActionListener(this.myUpdateAction);
        }
        return cb;
    }

    protected JPanel createAllOptionsPanel() {
        JComponent scopePanel;
        JPanel allOptionsPanel = new JPanel();
        JPanel findWhatPanel = this.createFindWhatPanel();
        JPanel usagesOptionsPanel = this.createUsagesOptionsPanel();
        int grids = 0;
        if (findWhatPanel != null) {
            ++grids;
        }
        if (usagesOptionsPanel != null) {
            ++grids;
        }
        if (grids != 0) {
            allOptionsPanel.setLayout(new GridLayout(1, grids, 8, 0));
            if (findWhatPanel != null) {
                allOptionsPanel.add(findWhatPanel);
            }
            if (usagesOptionsPanel != null) {
                allOptionsPanel.add(usagesOptionsPanel);
            }
        }
        if ((scopePanel = this.createSearchScopePanel()) != null) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)allOptionsPanel, "Center");
            panel.add((Component)scopePanel, "South");
            return panel;
        }
        return allOptionsPanel;
    }

    @Nullable
    protected abstract JPanel createFindWhatPanel();

    protected void addUsagesOptions(JPanel optionsPanel) {
        if (this.mySearchForTextOccurencesAvailable) {
            this.myCbToSearchForTextOccurences = this.addCheckboxToPanel(FindBundle.message("find.options.search.for.text.occurences.checkbox", new Object[0]), FindSettings.getInstance().isSearchForTextOccurences(), optionsPanel, false);
        }
        if (this.myIsShowInNewTabVisible) {
            this.myCbToSkipResultsWhenOneUsage = this.addCheckboxToPanel(FindBundle.message("find.options.skip.results.tab.with.one.usage.checkbox", new Object[0]), FindSettings.getInstance().isSkipResultsWithOneUsage(), optionsPanel, false);
        }
    }

    @Nullable
    protected JPanel createUsagesOptionsPanel() {
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.options.group", new Object[0])));
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        this.addUsagesOptions(optionsPanel);
        return optionsPanel.getComponents().length == 0 ? null : optionsPanel;
    }

    @Nullable
    private JComponent createSearchScopePanel() {
        if (this.isInFileOnly()) {
            return null;
        }
        JPanel optionsPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(FindBundle.message("find.scope.label", new Object[0]));
        optionsPanel.add((Component)label, "West");
        String scope = this.myFindUsagesOptions.searchScope.getDisplayName();
        this.myScopeCombo = new ScopeChooserCombo(this.myProject, this.mySearchInLibrariesAvailable, true, scope);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeCombo);
        optionsPanel.add((Component)((Object)this.myScopeCombo), "Center");
        label.setLabelFor(this.myScopeCombo.getComboBox());
        return optionsPanel;
    }

    @Nullable
    protected JComponent getPreferredFocusedControl() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myScopeCombo != null) {
            return this.myScopeCombo.getComboBox();
        }
        return this.getPreferredFocusedControl();
    }
}

