/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.GeneralToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.ProcessOutputConsumer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.BuildNumber;
import jetbrains.buildServer.messages.serviceMessages.BuildStatisticValue;
import jetbrains.buildServer.messages.serviceMessages.BuildStatus;
import jetbrains.buildServer.messages.serviceMessages.DefaultServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.ProgressFinish;
import jetbrains.buildServer.messages.serviceMessages.ProgressMessage;
import jetbrains.buildServer.messages.serviceMessages.ProgressStart;
import jetbrains.buildServer.messages.serviceMessages.PublishArtifacts;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import jetbrains.buildServer.messages.serviceMessages.TestStdOut;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputToGeneralTestEventsConverter
implements ProcessOutputConsumer {
    private static final Logger LOG = Logger.getInstance((String)OutputToGeneralTestEventsConverter.class.getName());
    private GeneralTestEventsProcessor myProcessor;
    private final MyServiceMessageVisitor myServiceMessageVisitor;
    private final String myTestFrameworkName;
    private final List<OutputChunk> myOutputChunks;

    public OutputToGeneralTestEventsConverter(@NotNull String testFrameworkName) {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter.<init> must not be null");
        }
        this.myTestFrameworkName = testFrameworkName;
        this.myServiceMessageVisitor = new MyServiceMessageVisitor();
        this.myOutputChunks = new ArrayList<OutputChunk>();
    }

    @Override
    public void setProcessor(GeneralTestEventsProcessor processor) {
        this.myProcessor = processor;
    }

    @Override
    public void process(String text, Key outputType) {
        if (outputType != ProcessOutputTypes.STDERR && outputType != ProcessOutputTypes.SYSTEM) {
            this.processStdOutConsistently(text, outputType);
        } else {
            this.processConsistentText(text, outputType, false);
        }
    }

    public void flushBufferBeforeTerminating() {
        this.flushStdOutputBuffer();
    }

    public void dispose() {
        this.setProcessor(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushStdOutputBuffer() {
        ArrayList<OutputChunk> chunks = new ArrayList<OutputChunk>();
        OutputChunk lastChunk = null;
        List<OutputChunk> list = this.myOutputChunks;
        synchronized (list) {
            for (OutputChunk chunk : this.myOutputChunks) {
                if (lastChunk != null && chunk.getKey() == lastChunk.getKey()) {
                    lastChunk.append(chunk.getText());
                    continue;
                }
                lastChunk = chunk;
                chunks.add(chunk);
            }
            this.myOutputChunks.clear();
        }
        boolean isTCLikeFakeOutput = chunks.size() == 1;
        for (OutputChunk chunk : chunks) {
            this.processConsistentText(chunk.getText(), chunk.getKey(), isTCLikeFakeOutput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStdOutConsistently(String text, Key outputType) {
        int textLength = text.length();
        if (textLength == 0) {
            return;
        }
        List<OutputChunk> list = this.myOutputChunks;
        synchronized (list) {
            this.myOutputChunks.add(new OutputChunk(outputType, text));
        }
        char lastChar = text.charAt(textLength - 1);
        if (lastChar == '\n' || lastChar == '\r') {
            this.flushStdOutputBuffer();
        }
    }

    private void processConsistentText(String text, Key outputType, boolean tcLikeFakeOutput) {
        try {
            ServiceMessage serviceMessage = ServiceMessage.parse((String)text);
            if (serviceMessage != null) {
                serviceMessage.visit((ServiceMessageVisitor)this.myServiceMessageVisitor);
            } else {
                if (text.equals("\n") && tcLikeFakeOutput) {
                    return;
                }
                this.fireOnUncapturedOutput(text, outputType);
            }
        }
        catch (ParseException e) {
            LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(this.myTestFrameworkName) + "Parsing error.", (Throwable)e);
        }
    }

    private void fireOnTestStarted(String testName, @Nullable String locationUrl) {
        this.assertNotNull(testName);
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestStarted(testName, locationUrl);
        }
    }

    private void fireOnTestFailure(String testName, String localizedMessage, String stackTrace, boolean isTestError) {
        this.assertNotNull(testName);
        this.assertNotNull(localizedMessage);
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestFailure(testName, localizedMessage, stackTrace, isTestError);
        }
    }

    private void fireOnTestIgnored(String testName, String ignoreComment, @Nullable String details) {
        this.assertNotNull(testName);
        this.assertNotNull(ignoreComment);
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestIgnored(testName, ignoreComment, details);
        }
    }

    private void fireOnTestFinished(String testName, int duration) {
        this.assertNotNull(testName);
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestFinished(testName, duration);
        }
    }

    private void fireOnCustomProgressTestsCategory(String categoryName, int testsCount) {
        this.assertNotNull(categoryName);
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            boolean disableCustomMode = StringUtil.isEmpty((String)categoryName);
            processor.onCustomProgressTestsCategory(disableCustomMode ? null : categoryName, disableCustomMode ? 0 : testsCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onCustomProgressTestFailed();
        }
    }

    private void fireOnTestOutput(String testName, String text, boolean stdOut) {
        this.assertNotNull(testName);
        this.assertNotNull(text);
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestOutput(testName, text, stdOut);
        }
    }

    private void fireOnUncapturedOutput(String text, Key outputType) {
        this.assertNotNull(text);
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onUncapturedOutput(text, outputType);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestsCountInSuite(count);
        }
    }

    private void fireOnSuiteStarted(String suiteName, @Nullable String locationUrl) {
        this.assertNotNull(suiteName);
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onSuiteStarted(suiteName, locationUrl);
        }
    }

    private void fireOnSuiteFinished(String suiteName) {
        this.assertNotNull(suiteName);
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onSuiteFinished(suiteName);
        }
    }

    private void fireOnErrorMsg(String localizedMessage, @Nullable String stackTrace) {
        this.assertNotNull(localizedMessage);
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onError(localizedMessage, stackTrace);
        }
    }

    private void assertNotNull(String s) {
        if (s == null) {
            LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(this.myTestFrameworkName) + " @NotNull value is expected.");
        }
    }

    private class MyServiceMessageVisitor
    extends DefaultServiceMessageVisitor {
        @NonNls
        public static final String KEY_TESTS_COUNT = "testCount";
        @NonNls
        private static final String ATTR_KEY_TEST_ERROR = "error";
        @NonNls
        private static final String ATTR_KEY_TEST_COUNT = "count";
        @NonNls
        private static final String ATTR_KEY_TEST_DURATION = "duration";
        @NonNls
        private static final String ATTR_KEY_LOCATION_URL = "locationHint";
        @NonNls
        private static final String ATTR_KEY_LOCATION_URL_OLD = "location";
        @NonNls
        private static final String ATTR_KEY_STACKTRACE_DETAILS = "details";
        @NonNls
        private static final String MESSAGE = "message";
        @NonNls
        private static final String ATTR_KEY_STATUS = "status";
        @NonNls
        private static final String ATTR_VALUE_STATUS_ERROR = "ERROR";
        @NonNls
        private static final String ATTR_VALUE_STATUS_WARNING = "WARNING";
        @NonNls
        private static final String ATTR_KEY_TEXT = "text";
        @NonNls
        private static final String ATTR_KEY_ERROR_DETAILS = "errorDetails";
        @NonNls
        public static final String CUSTOM_STATUS = "customProgressStatus";
        @NonNls
        private static final String ATTR_KEY_TEST_TYPE = "type";
        @NonNls
        private static final String ATTR_KEY_TESTS_CATEGORY = "testsCategory";
        @NonNls
        private static final String ATTR_VAL_TEST_STARTED = "testStarted";
        @NonNls
        private static final String ATTR_VAL_TEST_FAILED = "testFailed";

        private MyServiceMessageVisitor() {
        }

        public void visitTestSuiteStarted(@NotNull TestSuiteStarted suiteStarted) {
            if (suiteStarted == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitTestSuiteStarted must not be null");
            }
            String locationUrl = this.fetchTestLocation(suiteStarted);
            OutputToGeneralTestEventsConverter.this.fireOnSuiteStarted(suiteStarted.getSuiteName(), locationUrl);
        }

        @Nullable
        private String fetchTestLocation(TestSuiteStarted suiteStarted) {
            Map attrs = suiteStarted.getAttributes();
            String location = (String)attrs.get(ATTR_KEY_LOCATION_URL);
            if (location == null) {
                String oldLocation = (String)attrs.get(ATTR_KEY_LOCATION_URL_OLD);
                if (oldLocation != null) {
                    LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(OutputToGeneralTestEventsConverter.this.myTestFrameworkName) + "Test Runner API was changed for TeamCity 5.0 compatibility. Please use 'locationHint' attribute instead of 'location'.");
                    return oldLocation;
                }
                return null;
            }
            return location;
        }

        public void visitTestSuiteFinished(@NotNull TestSuiteFinished suiteFinished) {
            if (suiteFinished == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitTestSuiteFinished must not be null");
            }
            OutputToGeneralTestEventsConverter.this.fireOnSuiteFinished(suiteFinished.getSuiteName());
        }

        public void visitTestStarted(@NotNull TestStarted testStarted) {
            if (testStarted == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitTestStarted must not be null");
            }
            String locationUrl = (String)testStarted.getAttributes().get(ATTR_KEY_LOCATION_URL);
            OutputToGeneralTestEventsConverter.this.fireOnTestStarted(testStarted.getTestName(), locationUrl);
        }

        public void visitTestFinished(@NotNull TestFinished testFinished) {
            if (testFinished == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitTestFinished must not be null");
            }
            String durationStr = (String)testFinished.getAttributes().get(ATTR_KEY_TEST_DURATION);
            int duration = 0;
            if (!StringUtil.isEmptyOrSpaces((String)durationStr)) {
                duration = this.convertToInt(durationStr);
            }
            OutputToGeneralTestEventsConverter.this.fireOnTestFinished(testFinished.getTestName(), duration);
        }

        public void visitTestIgnored(@NotNull TestIgnored testIgnored) {
            if (testIgnored == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitTestIgnored must not be null");
            }
            String details = (String)testIgnored.getAttributes().get(ATTR_KEY_STACKTRACE_DETAILS);
            OutputToGeneralTestEventsConverter.this.fireOnTestIgnored(testIgnored.getTestName(), testIgnored.getIgnoreComment(), details);
        }

        public void visitTestStdOut(@NotNull TestStdOut testStdOut) {
            if (testStdOut == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitTestStdOut must not be null");
            }
            OutputToGeneralTestEventsConverter.this.fireOnTestOutput(testStdOut.getTestName(), testStdOut.getStdOut(), true);
        }

        public void visitTestStdErr(@NotNull TestStdErr testStdErr) {
            if (testStdErr == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitTestStdErr must not be null");
            }
            OutputToGeneralTestEventsConverter.this.fireOnTestOutput(testStdErr.getTestName(), testStdErr.getStdErr(), false);
        }

        public void visitTestFailed(@NotNull TestFailed testFailed) {
            if (testFailed == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitTestFailed must not be null");
            }
            boolean isTestError = testFailed.getAttributes().get(ATTR_KEY_TEST_ERROR) != null;
            OutputToGeneralTestEventsConverter.this.fireOnTestFailure(testFailed.getTestName(), testFailed.getFailureMessage(), testFailed.getStacktrace(), isTestError);
        }

        public void visitPublishArtifacts(@NotNull PublishArtifacts publishArtifacts) {
            if (publishArtifacts == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitPublishArtifacts must not be null");
            }
        }

        public void visitProgressMessage(@NotNull ProgressMessage progressMessage) {
            if (progressMessage == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitProgressMessage must not be null");
            }
        }

        public void visitProgressStart(@NotNull ProgressStart progressStart) {
            if (progressStart == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitProgressStart must not be null");
            }
        }

        public void visitProgressFinish(@NotNull ProgressFinish progressFinish) {
            if (progressFinish == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitProgressFinish must not be null");
            }
        }

        public void visitBuildStatus(@NotNull BuildStatus buildStatus) {
            if (buildStatus == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitBuildStatus must not be null");
            }
        }

        public void visitBuildNumber(@NotNull BuildNumber buildNumber) {
            if (buildNumber == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitBuildNumber must not be null");
            }
        }

        public void visitBuildStatisticValue(@NotNull BuildStatisticValue buildStatsValue) {
            if (buildStatsValue == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitBuildStatisticValue must not be null");
            }
        }

        public void visitServiceMessage(@NotNull ServiceMessage msg) {
            Map msgAttrs;
            String text;
            if (msg == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor.visitServiceMessage must not be null");
            }
            String name = msg.getMessageName();
            if (KEY_TESTS_COUNT.equals(name)) {
                this.processTestCountInSuite(msg);
            } else if (CUSTOM_STATUS.equals(name)) {
                this.processCustomStatus(msg);
            } else if (MESSAGE.equals(name) && !StringUtil.isEmpty((String)(text = (String)(msgAttrs = msg.getAttributes()).get(ATTR_KEY_TEXT)))) {
                String status = (String)msgAttrs.get(ATTR_KEY_STATUS);
                if (status.equals(ATTR_VALUE_STATUS_ERROR)) {
                    String stackTrace = (String)msgAttrs.get(ATTR_KEY_ERROR_DETAILS);
                    OutputToGeneralTestEventsConverter.this.fireOnErrorMsg(text, stackTrace);
                } else if (status.equals(ATTR_VALUE_STATUS_WARNING)) {
                    OutputToGeneralTestEventsConverter.this.fireOnUncapturedOutput(text, ProcessOutputTypes.STDERR);
                } else {
                    OutputToGeneralTestEventsConverter.this.fireOnUncapturedOutput(text, ProcessOutputTypes.STDOUT);
                }
            }
        }

        private void processTestCountInSuite(ServiceMessage msg) {
            String countStr = (String)msg.getAttributes().get(ATTR_KEY_TEST_COUNT);
            OutputToGeneralTestEventsConverter.this.fireOnTestsCountInSuite(this.convertToInt(countStr));
        }

        private int convertToInt(String countStr) {
            int count = 0;
            try {
                count = Integer.parseInt(countStr);
            }
            catch (NumberFormatException ex) {
                LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(OutputToGeneralTestEventsConverter.this.myTestFrameworkName) + "Parse integer error.", (Throwable)ex);
            }
            return count;
        }

        private void processCustomStatus(ServiceMessage msg) {
            Map attrs = msg.getAttributes();
            String msgType = (String)attrs.get(ATTR_KEY_TEST_TYPE);
            if (msgType != null) {
                if (msgType.equals(ATTR_VAL_TEST_STARTED)) {
                    OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestStarted();
                } else if (msgType.equals(ATTR_VAL_TEST_FAILED)) {
                    OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestFailed();
                }
                return;
            }
            String testsCategory = (String)attrs.get(ATTR_KEY_TESTS_CATEGORY);
            if (testsCategory != null) {
                String countStr = (String)msg.getAttributes().get(ATTR_KEY_TEST_COUNT);
                OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestsCategory(testsCategory, this.convertToInt(countStr));
                return;
            }
        }
    }

    private static class OutputChunk {
        private Key myKey;
        private String myText;

        private OutputChunk(Key key, String text) {
            this.myKey = key;
            this.myText = text;
        }

        public Key getKey() {
            return this.myKey;
        }

        public String getText() {
            return this.myText;
        }

        public void append(String text) {
            this.myText = this.myText + text;
        }
    }
}

