/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.applet;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.LocatableConfigurationType;
import com.intellij.execution.Location;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.applet.AppletConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AppletConfigurationType
implements LocatableConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactory((ConfigurationType)this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new AppletConfiguration("", project, this);
        }
    };
    private static final Icon ICON = IconLoader.getIcon((String)"/runConfigurations/applet.png");

    AppletConfigurationType() {
    }

    public String getDisplayName() {
        return ExecutionBundle.message((String)"applet.configuration.name", (Object[])new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return ExecutionBundle.message((String)"applet.configuration.description", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return ICON;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    public RunnerAndConfigurationSettings createConfigurationByLocation(Location location) {
        location = JavaExecutionUtil.stepIntoSingleClass((Location)location);
        Project project = location.getProject();
        PsiElement element = location.getPsiElement();
        PsiClass aClass = AppletConfigurationType.getAppletClass(element, PsiManager.getInstance((Project)project));
        if (aClass == null) {
            return null;
        }
        RunnerAndConfigurationSettingsImpl settings = RunManagerEx.getInstanceEx(project).createConfiguration("", this.getConfigurationFactories()[0]);
        AppletConfiguration configuration = (AppletConfiguration)settings.getConfiguration();
        configuration.MAIN_CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass);
        configuration.setModule(new JUnitUtil.ModuleOfClass().convert(aClass));
        configuration.setName(configuration.getGeneratedName());
        return settings;
    }

    public boolean isConfigurationByLocation(RunConfiguration configuration, Location location) {
        PsiClass aClass = AppletConfigurationType.getAppletClass(location.getPsiElement(), PsiManager.getInstance((Project)location.getProject()));
        return aClass != null && Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), (String)((AppletConfiguration)configuration).MAIN_CLASS_NAME);
    }

    private static PsiClass getAppletClass(PsiElement element, PsiManager manager) {
        while (element != null) {
            PsiClass aClass;
            if (element instanceof PsiClass && AppletConfigurationType.isAppletClass(aClass = (PsiClass)element, manager)) {
                return aClass;
            }
            element = element.getParent();
        }
        return null;
    }

    private static boolean isAppletClass(PsiClass aClass, PsiManager manager) {
        if (!PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)true)) {
            return false;
        }
        Module module = JavaExecutionUtil.findModule((PsiClass)aClass);
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithLibrariesScope((Module)module) : GlobalSearchScope.projectScope((Project)manager.getProject());
        PsiClass appletClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.applet.Applet", scope);
        if (appletClass != null && aClass.isInheritor(appletClass, true)) {
            return true;
        }
        appletClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("javax.swing.JApplet", scope);
        return appletClass != null && aClass.isInheritor(appletClass, true);
    }

    @NotNull
    public String getId() {
        if ("Applet" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/applet/AppletConfigurationType.getId must not return null");
        }
        return "Applet";
    }

    public static AppletConfigurationType getInstance() {
        return (AppletConfigurationType)ContainerUtil.findInstance((Object[])Extensions.getExtensions((ExtensionPointName)CONFIGURATION_TYPE_EP), AppletConfigurationType.class);
    }
}

