/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.ui.tree.render.BasicRendererProperties;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class ReferenceRenderer
implements Renderer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.ReferenceRenderer");
    protected BasicRendererProperties myProperties;

    protected ReferenceRenderer() {
        this("java.lang.Object");
    }

    protected ReferenceRenderer(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/ui/tree/render/ReferenceRenderer.<init> must not be null");
        }
        this.myProperties = new BasicRendererProperties();
        this.myProperties.setClassName(className);
    }

    public String getClassName() {
        return this.myProperties.getClassName();
    }

    public void setClassName(String className) {
        this.myProperties.setClassName(className);
    }

    @Override
    public Renderer clone() {
        try {
            ReferenceRenderer cloned = (ReferenceRenderer)super.clone();
            cloned.myProperties = this.myProperties.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isApplicable(Type type) {
        return type != null && type instanceof ReferenceType && DebuggerUtils.instanceOf((Type)type, (String)this.getClassName());
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myProperties.writeExternal(element);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myProperties.readExternal(element);
    }
}

