/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.impl.descriptors.data.SimpleDisplayKey;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.project.Project;

public class ThreadData
extends DescriptorData<ThreadDescriptorImpl> {
    private final ThreadReferenceProxyImpl myThread;

    public ThreadData(ThreadReferenceProxyImpl thread) {
        this.myThread = thread;
    }

    @Override
    protected ThreadDescriptorImpl createDescriptorImpl(Project project) {
        return new ThreadDescriptorImpl(this.myThread);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ThreadData)) {
            return false;
        }
        return ((ThreadData)object).myThread == this.myThread;
    }

    @Override
    public int hashCode() {
        return this.myThread.hashCode();
    }

    @Override
    public DisplayKey<ThreadDescriptorImpl> getDisplayKey() {
        return new SimpleDisplayKey<ThreadDescriptorImpl>(this.myThread);
    }
}

