/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import com.intellij.util.containers.SoftHashMap;
import java.util.Collection;
import java.util.Map;

public class CachingSearcher {
    private final Project myProject;
    private final Map<Pair<PsiElement, Boolean>, Collection<PsiReference>> myElementToReferencersMap = new SoftHashMap();

    public CachingSearcher(Project project) {
        this.myProject = project;
    }

    public Collection<PsiReference> findReferences(PsiElement element, boolean ignoreAccessScope) {
        Pair key = new Pair((Object)element, (Object)(ignoreAccessScope ? Boolean.TRUE : Boolean.FALSE));
        Collection psiReferences = this.myElementToReferencersMap.get(key);
        if (psiReferences == null) {
            GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)this.myProject);
            searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)searchScope, (FileType[])new FileType[]{StdFileTypes.JAVA});
            Query query = ReferencesSearch.search((PsiElement)element, (SearchScope)searchScope, (boolean)ignoreAccessScope);
            psiReferences = query.findAll();
            this.myElementToReferencersMap.put((Pair<PsiElement, Boolean>)key, psiReferences);
        }
        return psiReferences;
    }
}

