/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.packagingCompiler;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DestinationInfo {
    private VirtualFile myOutputFile;
    private final String myOutputPath;
    private final String myOutputFilePath;

    protected DestinationInfo(@NotNull String outputPath, @Nullable VirtualFile outputFile, @NotNull String outputFilePath) {
        if (outputPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/packagingCompiler/DestinationInfo.<init> must not be null");
        }
        if (outputFilePath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/compiler/impl/packagingCompiler/DestinationInfo.<init> must not be null");
        }
        this.myOutputFilePath = outputFilePath;
        this.myOutputFile = outputFile;
        this.myOutputPath = outputPath;
    }

    @NotNull
    public String getOutputPath() {
        String string = this.myOutputPath;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/packagingCompiler/DestinationInfo.getOutputPath must not return null");
        }
        return string;
    }

    @Nullable
    public VirtualFile getOutputFile() {
        return this.myOutputFile;
    }

    @NotNull
    public String getOutputFilePath() {
        String string = this.myOutputFilePath;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/packagingCompiler/DestinationInfo.getOutputFilePath must not return null");
        }
        return string;
    }

    public void update() {
        if (this.myOutputFile != null && !this.myOutputFile.isValid()) {
            this.myOutputFile = null;
        }
        if (this.myOutputFile == null) {
            this.myOutputFile = LocalFileSystem.getInstance().findFileByPath(this.myOutputFilePath);
        }
    }
}

