/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlWrongRootElementInspection
extends HtmlLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.XML_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"xml.inspection.wrong.root.element", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("XmlWrongRootElement" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection.getShortName must not return null");
        }
        return "XmlWrongRootElement";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    @Override
    protected void checkTag(final @NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection.checkTag must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection.checkTag must not be null");
        }
        if (!(tag.getParent() instanceof XmlTag)) {
            PsiFile psiFile = tag.getContainingFile();
            if (!(psiFile instanceof XmlFile)) {
                return;
            }
            XmlFile xmlFile = (XmlFile)psiFile;
            XmlDocument document = xmlFile.getDocument();
            if (document == null) {
                return;
            }
            XmlProlog prolog = document.getProlog();
            if (prolog == null || prolog.getUserData(DO_NOT_VALIDATE_KEY) != null) {
                return;
            }
            final XmlDoctype doctype = prolog.getDoctype();
            if (doctype == null) {
                return;
            }
            XmlElement nameElement = doctype.getNameElement();
            if (nameElement == null) {
                return;
            }
            String name = tag.getName();
            String text = nameElement.getText();
            if (tag instanceof HtmlTag) {
                name = name.toLowerCase();
                text = text.toLowerCase();
            }
            if (!name.equals(text) && !(name = XmlUtil.findLocalNameByQualifiedName(name)).equals(text)) {
                if (tag instanceof HtmlTag) {
                    return;
                }
                LocalQuickFix localQuickFix = new LocalQuickFix(){

                    @NotNull
                    public String getName() {
                        String string = XmlBundle.message((String)"change.root.element.to", (Object[])new Object[]{doctype.getNameElement().getText()});
                        if (string == null) {
                            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection$1.getName must not return null");
                        }
                        return string;
                    }

                    @NotNull
                    public String getFamilyName() {
                        String string = this.getName();
                        if (string == null) {
                            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection$1.getFamilyName must not return null");
                        }
                        return string;
                    }

                    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        if (project == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection$1.applyFix must not be null");
                        }
                        if (descriptor == null) {
                            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection$1.applyFix must not be null");
                        }
                        if (!CodeInsightUtilBase.prepareFileForWrite(tag.getContainingFile())) {
                            return;
                        }
                        new WriteCommandAction(project, new PsiFile[0]){

                            protected void run(Result result) throws Throwable {
                                tag.setName(doctype.getNameElement().getText());
                            }
                        }.execute();
                    }
                };
                holder.registerProblem(XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode()).getPsi(), XmlErrorMessages.message("wrong.root.element", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{localQuickFix});
                ASTNode astNode = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(tag.getNode());
                if (astNode != null) {
                    holder.registerProblem(astNode.getPsi(), XmlErrorMessages.message("wrong.root.element", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{localQuickFix});
                }
            }
        }
    }
}

