/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.zencoding;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateInvokationListener;
import com.intellij.codeInsight.template.zencoding.FilterToken;
import com.intellij.codeInsight.template.zencoding.MarkerToken;
import com.intellij.codeInsight.template.zencoding.NumberToken;
import com.intellij.codeInsight.template.zencoding.OperationToken;
import com.intellij.codeInsight.template.zencoding.State;
import com.intellij.codeInsight.template.zencoding.TemplateToken;
import com.intellij.codeInsight.template.zencoding.Token;
import com.intellij.codeInsight.template.zencoding.XmlZenCodingInterpreter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ZenCodingTemplate
implements CustomLiveTemplate {
    static final char MARKER = '$';
    private static final String OPERATIONS = ">+*";

    private static int parseNonNegativeInt(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/ZenCodingTemplate.parseNonNegativeInt must not be null");
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    @Nullable
    private List<Token> parse(@NotNull String text, @NotNull CustomTemplateCallback callback) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/ZenCodingTemplate.parse must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/ZenCodingTemplate.parse must not be null");
        }
        String filter = null;
        int filterDelim = text.indexOf(124);
        if (filterDelim >= 0 && filterDelim < text.length() - 1) {
            filter = text.substring(filterDelim + 1);
            text = text.substring(0, filterDelim);
        }
        text = text + '$';
        StringBuilder templateKeyBuilder = new StringBuilder();
        ArrayList<Token> result = new ArrayList<Token>();
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (i == n - 1 || i < n - 2 && OPERATIONS.indexOf(c) >= 0) {
                String key = templateKeyBuilder.toString();
                templateKeyBuilder = new StringBuilder();
                int num = ZenCodingTemplate.parseNonNegativeInt(key);
                if (num > 0) {
                    result.add(new NumberToken(num));
                } else {
                    TemplateToken token = this.parseTemplateKey(key, callback);
                    if (token == null) {
                        return null;
                    }
                    result.add(token);
                }
                result.add(i < n - 1 ? new OperationToken(c) : new MarkerToken());
                continue;
            }
            if (!Character.isWhitespace(c)) {
                templateKeyBuilder.append(c);
                continue;
            }
            return null;
        }
        if (filter != null) {
            result.add(new FilterToken(filter));
        }
        return result;
    }

    @Nullable
    protected abstract TemplateToken parseTemplateKey(String var1, CustomTemplateCallback var2);

    private static boolean check(@NotNull Collection<Token> tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/ZenCodingTemplate.check must not be null");
        }
        State state = State.WORD;
        for (Token token : tokens) {
            if (token instanceof MarkerToken) break;
            switch (state) {
                case OPERATION: {
                    if (token instanceof OperationToken) {
                        state = ((OperationToken)token).getSign() == '*' ? State.NUMBER : State.WORD;
                        break;
                    }
                    return false;
                }
                case WORD: {
                    if (token instanceof TemplateToken) {
                        state = State.OPERATION;
                        break;
                    }
                    return false;
                }
                case NUMBER: {
                    if (token instanceof NumberToken) {
                        state = State.AFTER_NUMBER;
                        break;
                    }
                    return false;
                }
                case AFTER_NUMBER: {
                    if (token instanceof OperationToken && ((OperationToken)token).getSign() != '*') {
                        state = State.WORD;
                        break;
                    }
                    return false;
                }
            }
        }
        return state == State.OPERATION || state == State.AFTER_NUMBER;
    }

    protected static String computeKey(Editor editor, int startOffset) {
        int index;
        int offset = editor.getCaretModel().getOffset();
        String s = ((Object)editor.getDocument().getCharsSequence().subSequence(startOffset, offset)).toString();
        for (index = 0; index < s.length() && Character.isWhitespace(s.charAt(index)); ++index) {
        }
        String key = s.substring(index);
        int lastWhitespaceIndex = -1;
        for (int i = 0; i < key.length(); ++i) {
            if (!Character.isWhitespace(key.charAt(i))) continue;
            lastWhitespaceIndex = i;
        }
        if (lastWhitespaceIndex >= 0 && lastWhitespaceIndex < key.length() - 1) {
            return key.substring(lastWhitespaceIndex + 1);
        }
        return key;
    }

    protected boolean checkTemplateKey(String key, CustomTemplateCallback callback) {
        List<Token> tokens = this.parse(key, callback);
        return tokens != null && ZenCodingTemplate.check(tokens);
    }

    @Override
    public void expand(String key, @NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/ZenCodingTemplate.expand must not be null");
        }
        this.expand(key, callback, null);
    }

    private void expand(String key, @NotNull CustomTemplateCallback callback, String surroundedText) {
        if (callback == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/ZenCodingTemplate.expand must not be null");
        }
        List<Token> tokens = this.parse(key, callback);
        assert (tokens != null);
        if (surroundedText == null) {
            Token token;
            if (tokens.size() == 2 && (token = tokens.get(0)) instanceof TemplateToken && key.equals(((TemplateToken)token).getKey()) && callback.findApplicableTemplates(key).size() > 1) {
                callback.startTemplate();
                return;
            }
            callback.deleteTemplateKey(key);
        }
        XmlZenCodingInterpreter.interpret(tokens, 0, callback, State.WORD, surroundedText);
    }

    @Override
    public void wrap(String selection, final @NotNull CustomTemplateCallback callback, @Nullable TemplateInvokationListener listener) {
        if (callback == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/ZenCodingTemplate.wrap must not be null");
        }
        InputValidatorEx validator = new InputValidatorEx(){

            public String getErrorText(String inputString) {
                if (!ZenCodingTemplate.this.checkTemplateKey(inputString, callback)) {
                    return XmlBundle.message((String)"zen.coding.incorrect.abbreviation.error", (Object[])new Object[0]);
                }
                return null;
            }

            public boolean checkInput(String inputString) {
                return this.getErrorText(inputString) == null;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        };
        String abbreviation = Messages.showInputDialog((Project)callback.getProject(), (String)XmlBundle.message((String)"zen.coding.enter.abbreviation.dialog.label", (Object[])new Object[0]), (String)XmlBundle.message((String)"zen.coding.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
        if (abbreviation != null) {
            this.doWrap(selection, abbreviation, callback, listener);
        }
    }

    @Override
    public boolean isApplicable(PsiFile file, int offset) {
        WebEditorOptions webEditorOptions = WebEditorOptions.getInstance();
        if (!webEditorOptions.isZenCodingEnabled()) {
            return false;
        }
        if (file == null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
        PsiElement element = CustomTemplateCallback.getContext(file, offset);
        return this.isApplicable(element);
    }

    protected abstract boolean isApplicable(@NotNull PsiElement var1);

    protected void doWrap(final String selection, final String abbreviation, final CustomTemplateCallback callback, final TemplateInvokationListener listener) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(callback.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        EditorModificationUtil.deleteSelectedText((Editor)callback.getEditor());
                        PsiDocumentManager.getInstance((Project)callback.getProject()).commitAllDocuments();
                        callback.fixInitialState();
                        ZenCodingTemplate.this.expand(abbreviation, callback, selection);
                        if (listener != null) {
                            listener.finished();
                        }
                    }
                }, CodeInsightBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null);
            }
        });
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = XmlBundle.message((String)"zen.coding.title", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/zencoding/ZenCodingTemplate.getTitle must not return null");
        }
        return string;
    }

    @Override
    public char getShortcut() {
        return (char)WebEditorOptions.getInstance().getZenCodingExpandShortcut();
    }
}

