/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiTypeParameter;
import org.jetbrains.annotations.NotNull;

public class ClassNameMacro
implements Macro {
    public String getName() {
        return "className";
    }

    public String getDescription() {
        return CodeInsightBundle.message((String)"macro.classname", (Object[])new Object[0]);
    }

    public String getDefaultValue() {
        return "";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/ClassNameMacro.calculateResult must not be null");
        }
        Project project = context.getProject();
        int templateStartOffset = context.getTemplateStartOffset();
        int offset = templateStartOffset > 0 ? context.getTemplateStartOffset() - 1 : context.getTemplateStartOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiClass aClass = null;
        for (PsiElement place = file.findElementAt(offset); place != null; place = place.getParent()) {
            if (place instanceof PsiClass && !(place instanceof PsiAnonymousClass) && !(place instanceof PsiTypeParameter)) {
                aClass = (PsiClass)place;
                PsiJavaToken lBrace = aClass.getLBrace();
                if (lBrace == null || offset >= lBrace.getTextOffset() || aClass.getContainingClass() == null) break;
                aClass = aClass.getContainingClass();
                break;
            }
            if (!(place instanceof PsiJavaFile)) continue;
            PsiClass[] classes = ((PsiJavaFile)place).getClasses();
            aClass = classes.length != 0 ? classes[0] : null;
            break;
        }
        if (aClass == null) {
            return null;
        }
        String result = aClass.getName();
        while (aClass.getContainingClass() != null && aClass.getContainingClass().getName() != null) {
            result = aClass.getContainingClass().getName() + "$" + result;
            aClass = aClass.getContainingClass();
        }
        return new TextResult(result);
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/ClassNameMacro.calculateQuickResult must not be null");
        }
        return null;
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/ClassNameMacro.calculateLookupItems must not be null");
        }
        return null;
    }
}

