/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateColors;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateTextLexer;
import com.intellij.codeInsight.template.impl.TemplateTokenType;
import com.intellij.lexer.CompositeLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class TemplateEditorUtil {
    private static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{TemplateTokenType.TEXT});

    public static Editor createEditor(boolean isReadOnly, CharSequence text) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document doc = editorFactory.createDocument(text);
        Editor editor = isReadOnly ? editorFactory.createViewer(doc) : editorFactory.createEditor(doc);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        EditorColorsScheme scheme = editor.getColorsScheme();
        scheme.setColor(EditorColors.CARET_ROW_COLOR, null);
        return editor;
    }

    public static void setHighlighter(Editor editor, TemplateContext templateContext) {
        TemplateContextType type;
        PlainSyntaxHighlighter baseHighlighter = null;
        TemplateContextType[] arr$ = TemplateManagerImpl.getAllContextTypes();
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || templateContext.isEnabled(type = arr$[i$]) && (baseHighlighter = type.createHighlighter()) != null); ++i$) {
        }
        if (baseHighlighter == null) {
            baseHighlighter = new PlainSyntaxHighlighter();
        }
        SyntaxHighlighter highlighter = TemplateEditorUtil.createTemplateTextHighlighter(baseHighlighter);
        ((EditorEx)editor).setHighlighter(new LexerEditorHighlighter(highlighter, EditorColorsManager.getInstance().getGlobalScheme()));
    }

    private static SyntaxHighlighter createTemplateTextHighlighter(SyntaxHighlighter original) {
        return new TemplateHighlighter(original);
    }

    private static class TemplateHighlighter
    extends SyntaxHighlighterBase {
        private final Lexer myLexer;
        private final SyntaxHighlighter myOriginalHighlighter;

        public TemplateHighlighter(SyntaxHighlighter original) {
            this.myOriginalHighlighter = original;
            Lexer originalLexer = original.getHighlightingLexer();
            TemplateTextLexer templateLexer = new TemplateTextLexer();
            templateLexer = new MergingLexerAdapter((Lexer)templateLexer, TOKENS_TO_MERGE);
            this.myLexer = new CompositeLexer(originalLexer, (Lexer)templateLexer){

                protected IElementType getCompositeTokenType(IElementType type1, IElementType type2) {
                    if (type2 == TemplateTokenType.VARIABLE) {
                        return type2;
                    }
                    return type1;
                }
            };
        }

        @NotNull
        public Lexer getHighlightingLexer() {
            Lexer lexer = this.myLexer;
            if (lexer == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/impl/TemplateEditorUtil$TemplateHighlighter.getHighlightingLexer must not return null");
            }
            return lexer;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
            TextAttributesKey[] textAttributesKeyArray;
            if (tokenType == TemplateTokenType.VARIABLE) {
                textAttributesKeyArray = TemplateHighlighter.pack((TextAttributesKey[])this.myOriginalHighlighter.getTokenHighlights(tokenType), (TextAttributesKey)TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES);
                if (textAttributesKeyArray == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/impl/TemplateEditorUtil$TemplateHighlighter.getTokenHighlights must not return null");
                return textAttributesKeyArray;
            }
            textAttributesKeyArray = this.myOriginalHighlighter.getTokenHighlights(tokenType);
            if (textAttributesKeyArray != null) return textAttributesKeyArray;
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/impl/TemplateEditorUtil$TemplateHighlighter.getTokenHighlights must not return null");
        }
    }
}

