/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EditorFoldingInfo {
    private static final Key<EditorFoldingInfo> KEY = Key.create((String)"EditorFoldingInfo.KEY");
    private final Map<FoldRegion, PsiElement> myFoldRegionToSmartPointerMap = new THashMap();

    public static EditorFoldingInfo get(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/EditorFoldingInfo.get must not be null");
        }
        EditorFoldingInfo info = (EditorFoldingInfo)editor.getUserData(KEY);
        if (info == null) {
            info = new EditorFoldingInfo();
            editor.putUserData(KEY, (Object)info);
        }
        return info;
    }

    public PsiElement getPsiElement(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/EditorFoldingInfo.getPsiElement must not be null");
        }
        PsiElement element = this.myFoldRegionToSmartPointerMap.get(region);
        return element != null && element.isValid() ? element : null;
    }

    public TextRange getPsiElementRange(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/EditorFoldingInfo.getPsiElementRange must not be null");
        }
        PsiElement element = this.getPsiElement(region);
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        boolean isInjected = injectedManager.isInjectedFragment(containingFile);
        TextRange range = element.getTextRange();
        if (isInjected) {
            range = injectedManager.injectedToHost(element, range);
        }
        return range;
    }

    public boolean isLightRegion(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/EditorFoldingInfo.isLightRegion must not be null");
        }
        return this.myFoldRegionToSmartPointerMap.get(region) == null;
    }

    public void addRegion(@NotNull FoldRegion region, @NotNull FoldingDescriptor element) {
        if (region == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/EditorFoldingInfo.addRegion must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/folding/impl/EditorFoldingInfo.addRegion must not be null");
        }
        this.myFoldRegionToSmartPointerMap.put(region, element.getElement().getPsi());
    }

    public void removeRegion(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/EditorFoldingInfo.removeRegion must not be null");
        }
        this.myFoldRegionToSmartPointerMap.remove(region);
    }

    public void dispose() {
        this.myFoldRegionToSmartPointerMap.clear();
    }

    public static void resetInfo(Editor editor) {
        EditorFoldingInfo info = (EditorFoldingInfo)editor.getUserData(KEY);
        if (info != null) {
            DocumentEx document = (DocumentEx)editor.getDocument();
            for (FoldRegion region : info.myFoldRegionToSmartPointerMap.keySet()) {
                document.removeRangeMarker((RangeMarkerEx)region);
            }
        }
        editor.putUserData(KEY, null);
    }
}

