/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class BackspaceHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public BackspaceHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void executeWriteAction(Editor editor, DataContext dataContext) {
        if (!this.handleBackspace(editor, dataContext)) {
            this.myOriginalHandler.execute(editor, dataContext);
        }
    }

    private boolean handleBackspace(Editor editor, DataContext dataContext) {
        BackspaceHandlerDelegate[] delegates;
        int injectedOffset;
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            return false;
        }
        if (editor.getSelectionModel().hasSelection()) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset() - 1;
        if (offset < 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        char c = chars.charAt(offset);
        Editor injectedEditor = TypedHandler.injectedEditorIfCharTypedIsSignificant(c, editor, file);
        if (injectedEditor != editor && BackspaceHandler.isOffsetInsideInjected(injectedEditor, injectedOffset = injectedEditor.getCaretModel().getOffset())) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(injectedEditor.getDocument());
            editor = injectedEditor;
            offset = injectedOffset - 1;
            chars = editor.getDocument().getCharsSequence();
        }
        for (BackspaceHandlerDelegate delegate : delegates = (BackspaceHandlerDelegate[])Extensions.getExtensions((ExtensionPointName)BackspaceHandlerDelegate.EP_NAME)) {
            delegate.beforeCharDeleted(c, file, editor);
        }
        FileType fileType = file.getFileType();
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file);
        HighlighterIterator hiterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        boolean wasClosingQuote = quoteHandler != null && quoteHandler.isClosingQuote(hiterator, offset);
        this.myOriginalHandler.execute(editor, dataContext);
        for (BackspaceHandlerDelegate delegate : delegates) {
            if (!delegate.charDeleted(c, file, editor)) continue;
            return true;
        }
        if (offset >= editor.getDocument().getTextLength()) {
            return true;
        }
        chars = editor.getDocument().getCharsSequence();
        if (c == '(' || c == '[' || c == '{') {
            boolean matched;
            char c1 = chars.charAt(offset);
            if (c == '(' && c1 != ')') {
                return true;
            }
            if (c == '[' && c1 != ']') {
                return true;
            }
            if (c == '{' && c1 != '}') {
                return true;
            }
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
            if (!braceMatcher.isLBraceToken(iterator, chars, fileType) && !braceMatcher.isRBraceToken(iterator, chars, fileType)) {
                return true;
            }
            int rparenOffset = BraceMatchingUtil.findRightmostRParen(iterator, iterator.getTokenType(), chars, fileType);
            if (rparenOffset >= 0 && (matched = BraceMatchingUtil.matchBrace(chars, fileType, iterator = ((EditorEx)editor).getHighlighter().createIterator(rparenOffset), false))) {
                return true;
            }
            editor.getDocument().deleteString(offset, offset + 1);
        } else if (c == '\"' || c == '\'') {
            char c1 = chars.charAt(offset);
            if (c1 != c) {
                return true;
            }
            if (wasClosingQuote) {
                return true;
            }
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
            if (quoteHandler == null || !quoteHandler.isOpeningQuote(iterator, offset)) {
                return true;
            }
            editor.getDocument().deleteString(offset, offset + 1);
        }
        return true;
    }

    private static boolean isOffsetInsideInjected(Editor injectedEditor, int injectedOffset) {
        TextRange rangeToEdit;
        if (injectedOffset == 0 || injectedOffset >= injectedEditor.getDocument().getTextLength()) {
            return false;
        }
        PsiFile injectedFile = ((EditorWindow)injectedEditor).getInjectedFile();
        InjectedLanguageManager ilm = InjectedLanguageManager.getInstance((Project)injectedFile.getProject());
        List editables = ilm.intersectWithAllEditableFragments(injectedFile, rangeToEdit = new TextRange(injectedOffset - 1, injectedOffset));
        return editables.size() == 1 && ((TextRange)editables.get(0)).equals((Object)rangeToEdit);
    }

    @Nullable
    public static LogicalPosition getBackspaceUnindentPosition(PsiFile file, Editor editor) {
        if (editor.getSelectionModel().hasSelection() || editor.getSelectionModel().hasBlockSelection()) {
            return null;
        }
        LogicalPosition caretPos = editor.getCaretModel().getLogicalPosition();
        if (caretPos.line == 0 || caretPos.column == 0) {
            return null;
        }
        int startCheckRange = editor.getDocument().getLineStartOffset(caretPos.line);
        int endCheckRange = startCheckRange + caretPos.column;
        CharSequence charSeq = editor.getDocument().getCharsSequence();
        for (int pos = startCheckRange; pos < endCheckRange; ++pos) {
            char c = charSeq.charAt(pos);
            if (c == '\t' || c == ' ' || c == '\n') continue;
            return null;
        }
        int indent = CodeStyleSettingsManager.getSettings((Project)file.getProject()).getIndentSize(file.getFileType());
        int column = (caretPos.column - 1) / indent * indent;
        if (column < 0) {
            column = 0;
        }
        return new LogicalPosition(caretPos.line, column);
    }
}

