/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.simple.PsiMethodInsertHandler;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

public class JavaMethodCallElement
extends LookupItem<PsiMethod>
implements TypedLookupItem {
    private static final Key<PsiSubstitutor> INFERENCE_SUBSTITUTOR = Key.create((String)"INFERENCE_SUBSTITUTOR");

    public JavaMethodCallElement(PsiMethod method) {
        super(method, method.getName());
        PsiType type = method.getReturnType();
        this.setTailType(PsiType.VOID.equals(type) ? TailType.SEMICOLON : TailType.NONE);
        this.setInsertHandler(new PsiMethodInsertHandler(method));
    }

    @Override
    public PsiType getType() {
        return this.getSubstitutor().substitute(this.getInferenceSubstitutor().substitute(((PsiMethod)this.getObject()).getReturnType()));
    }

    public void setInferenceSubstitutor(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaMethodCallElement.setInferenceSubstitutor must not be null");
        }
        this.setAttribute(INFERENCE_SUBSTITUTOR, substitutor);
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor substitutor = (PsiSubstitutor)this.getAttribute(LookupItem.SUBSTITUTOR);
        PsiSubstitutor psiSubstitutor = substitutor == null ? PsiSubstitutor.EMPTY : substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaMethodCallElement.getSubstitutor must not return null");
        }
        return psiSubstitutor;
    }

    public void setSubstitutor(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaMethodCallElement.setSubstitutor must not be null");
        }
        this.setAttribute(SUBSTITUTOR, substitutor);
    }

    @NotNull
    public PsiSubstitutor getInferenceSubstitutor() {
        PsiSubstitutor substitutor = this.getAttribute(INFERENCE_SUBSTITUTOR);
        PsiSubstitutor psiSubstitutor = substitutor == null ? PsiSubstitutor.EMPTY : substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaMethodCallElement.getInferenceSubstitutor must not return null");
        }
        return psiSubstitutor;
    }
}

