/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.codeStyle.CodeStyleMainPanel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesPanel;
import com.intellij.application.options.codeStyle.CodeStyleSettingsListener;
import com.intellij.application.options.codeStyle.CodeStyleSettingsPanelFactory;
import com.intellij.application.options.codeStyle.LanguageSelector;
import com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;

public class CodeStyleSchemesConfigurable
extends SearchableConfigurable.Parent.Abstract {
    private CodeStyleSchemesPanel myRootSchemesPanel;
    private CodeStyleSchemesModel myModel;
    private List<CodeStyleConfigurableWrapper> myPanels;
    private boolean myResetCompleted = false;
    private boolean myInitResetInvoked = false;
    private boolean myRevertCompleted = false;
    private boolean myApplyCompleted = false;
    private final Project myProject;
    private final LanguageSelector myLangSelector;

    public CodeStyleSchemesConfigurable(Project project) {
        this.myProject = project;
        this.myLangSelector = new LanguageSelector();
    }

    public JComponent createComponent() {
        this.myModel = this.ensureModel();
        return this.myRootSchemesPanel.getPanel();
    }

    public boolean hasOwnContent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeUIResources() {
        if (this.myPanels != null) {
            try {
                super.disposeUIResources();
                for (CodeStyleConfigurableWrapper panel : this.myPanels) {
                    panel.disposeUIResources();
                }
            }
            finally {
                this.myPanels = null;
                this.myModel = null;
                this.myRootSchemesPanel = null;
                this.myResetCompleted = false;
                this.myRevertCompleted = false;
                this.myApplyCompleted = false;
                this.myInitResetInvoked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reset() {
        if (!this.myInitResetInvoked) {
            try {
                if (this.myResetCompleted) return;
                try {
                    this.resetImpl();
                    return;
                }
                finally {
                    this.myResetCompleted = true;
                }
            }
            finally {
                this.myInitResetInvoked = true;
            }
        } else {
            this.revert();
        }
    }

    private void resetImpl() {
        if (this.myModel != null) {
            this.myModel.reset();
        }
        if (this.myPanels != null) {
            for (CodeStyleConfigurableWrapper panel : this.myPanels) {
                panel.resetPanel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetFromChild() {
        if (!this.myResetCompleted) {
            try {
                this.resetImpl();
            }
            finally {
                this.myResetCompleted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revert() {
        if (this.myModel.isSchemeListModified() || this.isSomeSchemeModified()) {
            this.myRevertCompleted = false;
        }
        if (!this.myRevertCompleted) {
            try {
                this.resetImpl();
            }
            finally {
                this.myRevertCompleted = true;
            }
        }
    }

    private boolean isSomeSchemeModified() {
        if (this.myPanels != null) {
            for (CodeStyleConfigurableWrapper panel : this.myPanels) {
                if (!panel.isPanelModified()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        if (!this.myApplyCompleted) {
            try {
                super.apply();
                for (CodeStyleScheme scheme : new ArrayList<CodeStyleScheme>(this.myModel.getSchemes())) {
                    boolean isDefaultModified = CodeStyleSchemesModel.cannotBeModified(scheme) && this.isSchemeModified(scheme);
                    if (!isDefaultModified) continue;
                    CodeStyleScheme newscheme = this.myModel.createNewScheme(null, scheme);
                    CodeStyleSettings settingsWillBeModified = scheme.getCodeStyleSettings();
                    CodeStyleSettings notModifiedSettings = settingsWillBeModified.clone();
                    ((CodeStyleSchemeImpl)scheme).setCodeStyleSettings(notModifiedSettings);
                    ((CodeStyleSchemeImpl)newscheme).setCodeStyleSettings(settingsWillBeModified);
                    this.myModel.addScheme(newscheme, false);
                    if (this.myModel.getSelectedScheme() != scheme) continue;
                    this.myModel.selectScheme(newscheme, (Object)this);
                }
                for (CodeStyleConfigurableWrapper panel : this.myPanels) {
                    panel.applyPanel();
                }
                this.myModel.apply();
                EditorFactory.getInstance().refreshAllEditors();
            }
            finally {
                this.myApplyCompleted = true;
            }
        }
    }

    private boolean isSchemeModified(CodeStyleScheme scheme) {
        for (CodeStyleConfigurableWrapper panel : this.myPanels) {
            if (!panel.isPanelModified(scheme)) continue;
            return true;
        }
        return false;
    }

    protected Configurable[] buildConfigurables() {
        this.myPanels = new ArrayList<CodeStyleConfigurableWrapper>();
        for (final CodeStyleSettingsProvider provider : (CodeStyleSettingsProvider[])Extensions.getExtensions((ExtensionPointName)CodeStyleSettingsProvider.EXTENSION_POINT_NAME)) {
            this.myPanels.add(new CodeStyleConfigurableWrapper(provider, new CodeStyleSettingsPanelFactory(){

                @Override
                public NewCodeStyleSettingsPanel createPanel(CodeStyleScheme scheme) {
                    return new NewCodeStyleSettingsPanel(provider.createSettingsPage(scheme.getCodeStyleSettings(), CodeStyleSchemesConfigurable.this.ensureModel().getCloneSettings(scheme)));
                }
            }));
        }
        return this.myPanels.toArray(new Configurable[this.myPanels.size()]);
    }

    private CodeStyleSchemesModel ensureModel() {
        if (this.myModel == null) {
            this.myModel = new CodeStyleSchemesModel(this.myProject);
            this.myRootSchemesPanel = new CodeStyleSchemesPanel(this.myModel);
            this.myModel.addListener(new CodeStyleSettingsListener(){

                @Override
                public void currentSchemeChanged(Object source) {
                    if (source != CodeStyleSchemesConfigurable.this.myRootSchemesPanel) {
                        CodeStyleSchemesConfigurable.this.myRootSchemesPanel.onSelectedSchemeChanged();
                    }
                }

                @Override
                public void schemeListChanged() {
                    CodeStyleSchemesConfigurable.this.myRootSchemesPanel.resetSchemesCombo();
                }

                @Override
                public void currentSettingsChanged() {
                }

                @Override
                public void usePerProjectSettingsOptionChanged() {
                    CodeStyleSchemesConfigurable.this.myRootSchemesPanel.usePerProjectSettingsOptionChanged();
                }

                @Override
                public void schemeChanged(CodeStyleScheme scheme) {
                }
            });
        }
        return this.myModel;
    }

    public String getDisplayName() {
        return "Code Style";
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableCodeStyle.png");
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.globalcodestyle";
    }

    public static CodeStyleSchemesConfigurable getInstance(Project project) {
        return (CodeStyleSchemesConfigurable)ShowSettingsUtil.getInstance().findProjectConfigurable(project, CodeStyleSchemesConfigurable.class);
    }

    public void selectPage(Class pageToSelect) {
    }

    public boolean isModified() {
        if (this.myModel != null) {
            boolean schemeListModified = this.myModel.isSchemeListModified();
            if (schemeListModified) {
                this.myApplyCompleted = false;
                this.myRevertCompleted = false;
            }
            return schemeListModified;
        }
        return false;
    }

    public String getId() {
        return "preferences.sourceCode";
    }

    public HashSet<OptionDescription> processOptions() {
        return new HashSet<OptionDescription>();
    }

    private class CodeStyleConfigurableWrapper
    implements SearchableConfigurable,
    Configurable.NoScroll {
        private boolean myInitialResetInvoked;
        private CodeStyleMainPanel myPanel;
        private final CodeStyleSettingsProvider myProvider;
        private final CodeStyleSettingsPanelFactory myFactory;

        public CodeStyleConfigurableWrapper(CodeStyleSettingsProvider provider, CodeStyleSettingsPanelFactory factory) {
            this.myProvider = provider;
            this.myFactory = factory;
            this.myInitialResetInvoked = false;
        }

        @Nls
        public String getDisplayName() {
            String displayName = this.myProvider.getConfigurableDisplayName();
            if (displayName != null) {
                return displayName;
            }
            return this.ensurePanel().getDisplayName();
        }

        public Icon getIcon() {
            return null;
        }

        public String getHelpTopic() {
            return this.ensurePanel().getHelpTopic();
        }

        private CodeStyleMainPanel ensurePanel() {
            if (this.myPanel == null) {
                this.myPanel = new CodeStyleMainPanel(CodeStyleSchemesConfigurable.this.ensureModel(), CodeStyleSchemesConfigurable.this.myLangSelector, this.myFactory);
            }
            return this.myPanel;
        }

        public JComponent createComponent() {
            return this.ensurePanel();
        }

        public boolean isModified() {
            boolean someSchemeModified = this.ensurePanel().isModified();
            if (someSchemeModified) {
                CodeStyleSchemesConfigurable.this.myApplyCompleted = false;
                CodeStyleSchemesConfigurable.this.myRevertCompleted = false;
            }
            return someSchemeModified;
        }

        public void apply() throws ConfigurationException {
            CodeStyleSchemesConfigurable.this.apply();
        }

        public void resetPanel() {
            if (this.myPanel != null) {
                this.myPanel.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            if (!this.myInitialResetInvoked) {
                try {
                    CodeStyleSchemesConfigurable.this.resetFromChild();
                }
                finally {
                    this.myInitialResetInvoked = true;
                }
            } else {
                CodeStyleSchemesConfigurable.this.revert();
            }
        }

        public String getId() {
            return "preferences.sourceCode." + this.getDisplayName();
        }

        public Runnable enableSearch(String option) {
            return null;
        }

        public void disposeUIResources() {
            if (this.myPanel != null) {
                this.myPanel.disposeUIResources();
            }
        }

        public boolean isPanelModified(CodeStyleScheme scheme) {
            return this.ensurePanel().isModified(scheme);
        }

        public boolean isPanelModified() {
            return this.ensurePanel().isModified();
        }

        public void applyPanel() {
            this.ensurePanel().apply();
        }
    }
}

