/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.config.EclipseModuleManager;
import org.jetbrains.idea.eclipse.conversion.ConversionException;
import org.jetbrains.idea.eclipse.conversion.EJavadocUtil;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;

public class EclipseClasspathWriter {
    private ModuleRootModel myModel;
    private Map<String, Element> myOldEntries = new HashMap<String, Element>();

    public EclipseClasspathWriter(ModuleRootModel model) {
        this.myModel = model;
    }

    public void writeClasspath(Element classpathElement, @Nullable Element oldRoot) throws ConversionException {
        String url;
        OrderEntry orderEntry2;
        if (oldRoot != null) {
            for (Object o : oldRoot.getChildren("classpathentry")) {
                Element oldChild = (Element)o;
                String oldKind = oldChild.getAttributeValue("kind");
                String oldPath = oldChild.getAttributeValue("path");
                this.myOldEntries.put(oldKind + EclipseClasspathWriter.getJREKey(oldPath), oldChild);
            }
        }
        for (OrderEntry orderEntry2 : this.myModel.getOrderEntries()) {
            this.createClasspathEntry(orderEntry2, classpathElement);
        }
        String outputPath = "bin";
        VirtualFile contentRoot = EPathUtil.getContentRoot(this.myModel);
        VirtualFile output = ((CompilerModuleExtension)this.myModel.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputPath();
        if (contentRoot != null && output != null && VfsUtil.isAncestor((VirtualFile)contentRoot, (VirtualFile)output, (boolean)false)) {
            outputPath = EPathUtil.collapse2EclipsePath(output.getUrl(), this.myModel);
        } else if (output == null && (url = ((CompilerModuleExtension)this.myModel.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputUrl()) != null) {
            outputPath = EPathUtil.collapse2EclipsePath(url, this.myModel);
        }
        orderEntry2 = this.addOrderEntry("output", outputPath, classpathElement);
        EclipseClasspathWriter.setAttributeIfAbsent((Element)orderEntry2, "path", "bin");
    }

    private void createClasspathEntry(OrderEntry entry, Element classpathRoot) throws ConversionException {
        if (entry instanceof ModuleSourceOrderEntry) {
            ContentEntry[] entries;
            ModuleRootModel rootModel = ((ModuleSourceOrderEntry)entry).getRootModel();
            for (ContentEntry contentEntry : entries = rootModel.getContentEntries()) {
                VirtualFile contentRoot = contentEntry.getFile();
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    String linkedPath;
                    String relativePath = EPathUtil.collapse2EclipsePath(sourceFolder.getUrl(), this.myModel);
                    if (contentRoot != EPathUtil.getContentRoot(rootModel) && (linkedPath = EclipseModuleManager.getInstance(entry.getOwnerModule()).getEclipseLinkedSrcVariablePath(sourceFolder.getUrl())) != null) {
                        relativePath = linkedPath;
                    }
                    this.addOrderEntry("src", relativePath, classpathRoot);
                }
            }
        } else if (entry instanceof ModuleOrderEntry) {
            Element orderEntry = this.addOrderEntry("src", "/" + ((ModuleOrderEntry)entry).getModuleName(), classpathRoot);
            EclipseClasspathWriter.setAttributeIfAbsent(orderEntry, "combineaccessrules", "false");
            EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)entry);
        } else if (entry instanceof LibraryOrderEntry) {
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
            String libraryName = libraryOrderEntry.getLibraryName();
            if (libraryOrderEntry.isModuleLevel()) {
                String[] files = libraryOrderEntry.getUrls(OrderRootType.CLASSES);
                if (files.length > 0) {
                    if (libraryName != null && libraryName.contains("junit") && Comparing.strEqual((String)files[0], (String)EclipseClasspathReader.getJunitClsUrl(libraryName.contains("4")))) {
                        Element orderEntry = this.addOrderEntry("con", "org.eclipse.jdt.junit.JUNIT_CONTAINER/" + libraryName.substring("junit".length()), classpathRoot);
                        EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)libraryOrderEntry);
                    } else {
                        String eclipseSrcVariablePath;
                        String srcRelativePath;
                        String eclipseVariablePath = EclipseModuleManager.getInstance(libraryOrderEntry.getOwnerModule()).getEclipseVariablePath(files[0]);
                        Element orderEntry = eclipseVariablePath != null ? this.addOrderEntry("var", eclipseVariablePath, classpathRoot) : this.addOrderEntry("lib", EPathUtil.collapse2EclipsePath(files[0], this.myModel), classpathRoot);
                        String[] srcFiles = libraryOrderEntry.getUrls(OrderRootType.SOURCES);
                        if (srcFiles.length == 0) {
                            srcRelativePath = null;
                            eclipseSrcVariablePath = null;
                        } else {
                            String lastSourceRoot = srcFiles[srcFiles.length - 1];
                            srcRelativePath = EPathUtil.collapse2EclipsePath(lastSourceRoot, this.myModel);
                            eclipseSrcVariablePath = EclipseModuleManager.getInstance(libraryOrderEntry.getOwnerModule()).getEclipseSrcVariablePath(lastSourceRoot);
                        }
                        EclipseClasspathWriter.setOrRemoveAttribute(orderEntry, "sourcepath", eclipseSrcVariablePath != null ? eclipseSrcVariablePath : srcRelativePath);
                        EJavadocUtil.setupJavadocAttributes(orderEntry, libraryOrderEntry, this.myModel);
                        EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)libraryOrderEntry);
                    }
                }
            } else {
                Element orderEntry = EclipseModuleManager.getInstance(libraryOrderEntry.getOwnerModule()).getUnknownCons().contains(libraryName) ? this.addOrderEntry("con", libraryName, classpathRoot) : (Comparing.strEqual((String)libraryName, (String)"ECLIPSE") ? this.addOrderEntry("con", "org.eclipse.pde.core.requiredPlugins", classpathRoot) : this.addOrderEntry("con", "org.eclipse.jdt.USER_LIBRARY/" + libraryName, classpathRoot));
                EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)libraryOrderEntry);
            }
        } else if (entry instanceof JdkOrderEntry) {
            if (entry instanceof InheritedJdkOrderEntry) {
                if (!EclipseModuleManager.getInstance(entry.getOwnerModule()).isForceConfigureJDK()) {
                    this.addOrderEntry("con", "org.eclipse.jdt.launching.JRE_CONTAINER", classpathRoot);
                }
            } else {
                String jdkLink;
                Sdk jdk = ((JdkOrderEntry)entry).getJdk();
                if (jdk == null) {
                    jdkLink = "org.eclipse.jdt.launching.JRE_CONTAINER";
                } else {
                    jdkLink = "org.eclipse.jdt.launching.JRE_CONTAINER";
                    if (jdk.getSdkType() instanceof JavaSdkType) {
                        jdkLink = jdkLink + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
                    }
                    jdkLink = jdkLink + "/" + jdk.getName();
                }
                this.addOrderEntry("con", jdkLink, classpathRoot);
            }
        } else {
            throw new ConversionException("Unknown EclipseProjectModel.ClasspathEntry: " + entry.getClass());
        }
    }

    private Element addOrderEntry(String kind, String path, Element classpathRoot) {
        Element element = this.myOldEntries.get(kind + EclipseClasspathWriter.getJREKey(path));
        if (element != null) {
            Element clonedElement = (Element)element.clone();
            classpathRoot.addContent(clonedElement);
            return clonedElement;
        }
        Element orderEntry = new Element("classpathentry");
        orderEntry.setAttribute("kind", kind);
        if (path != null) {
            orderEntry.setAttribute("path", path);
        }
        classpathRoot.addContent(orderEntry);
        return orderEntry;
    }

    private static String getJREKey(String path) {
        return path.startsWith("org.eclipse.jdt.launching.JRE_CONTAINER") ? "org.eclipse.jdt.launching.JRE_CONTAINER" : path;
    }

    private static void setExported(Element orderEntry, ExportableOrderEntry dependency) {
        EclipseClasspathWriter.setOrRemoveAttribute(orderEntry, "exported", dependency.isExported() ? "true" : null);
    }

    private static void setOrRemoveAttribute(Element element, String name, String value) {
        if (value != null) {
            element.setAttribute(name, value);
        } else {
            element.removeAttribute(name);
        }
    }

    private static void setAttributeIfAbsent(Element element, String name, String value) {
        if (element.getAttribute(name) == null) {
            element.setAttribute(name, value);
        }
    }
}

