/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class RemovePropertyFix
implements IntentionAction {
    private final Property myProperty;

    public RemovePropertyFix(@NotNull Property origProperty) {
        if (origProperty == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/RemovePropertyFix.<init> must not be null");
        }
        this.myProperty = origProperty;
    }

    @NotNull
    public String getText() {
        String string = PropertiesBundle.message("remove.property.intention.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/RemovePropertyFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/RemovePropertyFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/RemovePropertyFix.isAvailable must not be null");
        }
        return file.isValid() && this.myProperty != null && this.myProperty.isValid() && this.myProperty.getManager().isInProject((PsiElement)this.myProperty);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/RemovePropertyFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite((PsiFile)file)) {
            return;
        }
        this.myProperty.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

