/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.gotosymbol;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoToSymbolProvider
implements ChooseByNameContributor {
    protected abstract void addNames(@NotNull Module var1, Set<String> var2);

    protected abstract void addItems(@NotNull Module var1, String var2, List<NavigationItem> var3);

    protected abstract boolean acceptModule(Module var1);

    protected static void addNewNames(@NotNull List<? extends DomElement> elements, Set<String> existingNames) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/gotosymbol/GoToSymbolProvider.addNewNames must not be null");
        }
        for (DomElement domElement : elements) {
            existingNames.add(domElement.getGenericInfo().getElementName(domElement));
        }
    }

    @Override
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        Module[] modules;
        HashSet<String> result = new HashSet<String>();
        for (Module module : modules = ModuleManager.getInstance(project).getModules()) {
            if (!this.acceptModule(module)) continue;
            this.addNames(module, result);
        }
        return ArrayUtil.toStringArray(result);
    }

    @Override
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        Module[] modules;
        ArrayList<NavigationItem> result = new ArrayList<NavigationItem>();
        for (Module module : modules = ModuleManager.getInstance(project).getModules()) {
            if (!this.acceptModule(module)) continue;
            this.addItems(module, name, result);
        }
        return result.toArray(new NavigationItem[result.size()]);
    }

    @Nullable
    protected static NavigationItem createNavigationItem(DomElement domElement) {
        GenericDomValue name = domElement.getGenericInfo().getNameDomElement(domElement);
        assert (name != null);
        XmlElement psiElement = name.getXmlElement();
        String value = name.getStringValue();
        if (psiElement == null || value == null) {
            return null;
        }
        Icon icon = ElementPresentationManager.getIcon(domElement);
        return GoToSymbolProvider.createNavigationItem(psiElement, value, icon);
    }

    @NotNull
    protected static NavigationItem createNavigationItem(@NotNull PsiElement element, @NotNull @NonNls String text, @Nullable Icon icon) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/gotosymbol/GoToSymbolProvider.createNavigationItem must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/model/gotosymbol/GoToSymbolProvider.createNavigationItem must not be null");
        }
        BaseNavigationItem baseNavigationItem = new BaseNavigationItem(element, text, icon);
        if (baseNavigationItem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/gotosymbol/GoToSymbolProvider.createNavigationItem must not return null");
        }
        return baseNavigationItem;
    }

    public static class BaseNavigationItem
    extends FakePsiElement {
        private final PsiElement myPsiElement;
        private final String myText;
        private final Icon myIcon;

        public BaseNavigationItem(@NotNull PsiElement psiElement, @NotNull @NonNls String text, @Nullable Icon icon) {
            if (psiElement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/gotosymbol/GoToSymbolProvider$BaseNavigationItem.<init> must not be null");
            }
            if (text == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/model/gotosymbol/GoToSymbolProvider$BaseNavigationItem.<init> must not be null");
            }
            this.myPsiElement = psiElement;
            this.myText = text;
            this.myIcon = icon;
        }

        public PsiElement getNavigationElement() {
            return this.myPsiElement;
        }

        public Icon getIcon(boolean flags) {
            return this.myIcon;
        }

        public ItemPresentation getPresentation() {
            return new ItemPresentation(){

                @Override
                public String getPresentableText() {
                    return BaseNavigationItem.this.myText;
                }

                @Override
                @Nullable
                public String getLocationString() {
                    return '(' + BaseNavigationItem.this.myPsiElement.getContainingFile().getName() + ')';
                }

                @Override
                @Nullable
                public Icon getIcon(boolean open) {
                    return BaseNavigationItem.this.myIcon;
                }

                @Override
                @Nullable
                public TextAttributesKey getTextAttributesKey() {
                    return null;
                }
            };
        }

        public PsiElement getParent() {
            return this.myPsiElement.getParent();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            BaseNavigationItem that = (BaseNavigationItem)((Object)o);
            if (this.myPsiElement != null ? !this.myPsiElement.equals(that.myPsiElement) : that.myPsiElement != null) {
                return false;
            }
            return !(this.myText != null ? !this.myText.equals(that.myText) : that.myText != null);
        }

        public int hashCode() {
            int result = this.myPsiElement != null ? this.myPsiElement.hashCode() : 0;
            result = 31 * result + (this.myText != null ? this.myText.hashCode() : 0);
            return result;
        }
    }
}

