/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.RowEditableTableModel;
import com.intellij.ui.TableUtil;
import com.intellij.ui.UIBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditableRowTable {
    private EditableRowTable() {
    }

    public static JPanel createButtonsTable(final JTable table, final RowEditableTableModel tableModel, boolean addMnemonics) {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        buttonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 2;
        gbConstraints.insets = new Insets(2, 4, 2, 4);
        final JButton addButton = new JButton();
        addButton.setText(addMnemonics ? UIBundle.message((String)"row.add", (Object[])new Object[0]) : UIBundle.message((String)"row.add.without.mnemonic", (Object[])new Object[0]));
        addButton.setDefaultCapable(false);
        buttonsPanel.add((Component)addButton, gbConstraints);
        final JButton removeButton = new JButton();
        removeButton.setText(addMnemonics ? UIBundle.message((String)"row.remove", (Object[])new Object[0]) : UIBundle.message((String)"row.remove.without.mnemonic", (Object[])new Object[0]));
        removeButton.setDefaultCapable(false);
        buttonsPanel.add((Component)removeButton, gbConstraints);
        final JButton upButton = new JButton();
        upButton.setText(addMnemonics ? UIBundle.message((String)"row.move.up", (Object[])new Object[0]) : UIBundle.message((String)"row.move.up.without.mnemonic", (Object[])new Object[0]));
        upButton.setDefaultCapable(false);
        buttonsPanel.add((Component)upButton, gbConstraints);
        final JButton downButton = new JButton();
        downButton.setText(addMnemonics ? UIBundle.message((String)"row.move.down", (Object[])new Object[0]) : UIBundle.message((String)"row.move.down.without.mnemonic", (Object[])new Object[0]));
        downButton.setDefaultCapable(false);
        buttonsPanel.add((Component)downButton, gbConstraints);
        gbConstraints.weighty = 1.0;
        buttonsPanel.add((Component)new JPanel(), gbConstraints);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.stopEditing((JTable)table);
                tableModel.addRow();
                int index = tableModel.getRowCount() - 1;
                table.editCellAt(index, 0);
                table.setRowSelectionInterval(index, index);
                table.setColumnSelectionInterval(0, 0);
                Component editorComponent = table.getEditorComponent();
                if (editorComponent != null) {
                    Rectangle bounds = editorComponent.getBounds();
                    table.scrollRectToVisible(bounds);
                    editorComponent.requestFocus();
                }
            }
        });
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.stopEditing((JTable)table);
                int index = table.getSelectedRow();
                if (0 <= index && index < tableModel.getRowCount()) {
                    tableModel.removeRow(index);
                    if (index < tableModel.getRowCount()) {
                        table.setRowSelectionInterval(index, index);
                    } else if (index > 0) {
                        table.setRowSelectionInterval(index - 1, index - 1);
                    }
                    EditableRowTable.updateButtons(table, tableModel, addButton, removeButton, upButton, downButton);
                }
                table.requestFocus();
            }
        });
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.stopEditing((JTable)table);
                int index = table.getSelectedRow();
                if (0 < index && index < tableModel.getRowCount()) {
                    tableModel.exchangeRows(index, index - 1);
                    table.setRowSelectionInterval(index - 1, index - 1);
                }
                table.requestFocus();
            }
        });
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.stopEditing((JTable)table);
                int index = table.getSelectedRow();
                if (0 <= index && index < tableModel.getRowCount() - 1) {
                    tableModel.exchangeRows(index, index + 1);
                    table.setRowSelectionInterval(index + 1, index + 1);
                }
                table.requestFocus();
            }
        });
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EditableRowTable.updateButtons(table, tableModel, addButton, removeButton, upButton, downButton);
            }
        });
        EditableRowTable.updateButtons(table, tableModel, addButton, removeButton, upButton, downButton);
        return buttonsPanel;
    }

    private static void updateButtons(JTable table, RowEditableTableModel tableModel, JButton addButton, JButton removeButton, JButton upButton, JButton downButton) {
        if (table.isEnabled()) {
            int index = table.getSelectedRow();
            if (0 <= index && index < tableModel.getRowCount()) {
                removeButton.setEnabled(true);
                upButton.setEnabled(index > 0);
                downButton.setEnabled(index < tableModel.getRowCount() - 1);
            } else {
                removeButton.setEnabled(false);
                upButton.setEnabled(false);
                downButton.setEnabled(false);
            }
            addButton.setEnabled(true);
        }
    }
}

