/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.lang.Language;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.IdeaTestCase;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.DefaultLightProjectDescriptor;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.JavaCodeInsightTestFixture;
import com.intellij.testFramework.fixtures.JavaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class LightCodeInsightFixtureTestCase
extends UsefulTestCase {
    public static final LightProjectDescriptor JAVA_1_4 = new LightProjectDescriptor(){

        public ModuleType getModuleType() {
            return StdModuleTypes.JAVA;
        }

        public Sdk getSdk() {
            return JavaSdkImpl.getMockJdk((String)"java 1.4");
        }

        public void configureModule(Module module, ModifiableRootModel model, ContentEntry contentEntry) {
        }
    };
    public static final LightProjectDescriptor JAVA_1_5 = new DefaultLightProjectDescriptor();
    protected JavaCodeInsightTestFixture myFixture;
    protected Module myModule;

    protected LightCodeInsightFixtureTestCase() {
        IdeaTestCase.initPlatformPrefix();
    }

    protected void setUp() throws Exception {
        super.setUp();
        IdeaTestFixtureFactory factory = IdeaTestFixtureFactory.getFixtureFactory();
        TestFixtureBuilder fixtureBuilder = factory.createLightFixtureBuilder(this.getProjectDescriptor());
        IdeaProjectTestFixture fixture = (IdeaProjectTestFixture)fixtureBuilder.getFixture();
        this.myFixture = JavaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture(fixture, (TempDirTestFixture)new LightTempDirTestFixtureImpl(true));
        this.myFixture.setUp();
        this.myFixture.setTestDataPath(this.getTestDataPath());
        this.myModule = this.myFixture.getModule();
    }

    @NonNls
    protected String getBasePath() {
        return "";
    }

    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        LightProjectDescriptor lightProjectDescriptor = JAVA_1_5;
        if (lightProjectDescriptor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/LightCodeInsightFixtureTestCase.getProjectDescriptor must not return null");
        }
        return lightProjectDescriptor;
    }

    @NonNls
    protected final String getTestDataPath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/') + this.getBasePath();
    }

    protected void tearDown() throws Exception {
        this.myFixture.tearDown();
        this.myFixture = null;
        this.myModule = null;
        super.tearDown();
    }

    protected void runTest() throws Throwable {
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            @Override
            protected void run(Result result) throws Throwable {
                LightCodeInsightFixtureTestCase.super.runTest();
            }
        }.execute();
    }

    protected Project getProject() {
        return this.myFixture.getProject();
    }

    protected PsiManager getPsiManager() {
        return PsiManager.getInstance(this.getProject());
    }

    public PsiElementFactory getElementFactory() {
        return JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
    }

    protected PsiFile createLightFile(FileType fileType, String text) {
        return PsiFileFactory.getInstance(this.getProject()).createFileFromText("a." + fileType.getDefaultExtension(), fileType, (CharSequence)text);
    }

    public PsiFile createLightFile(String fileName, Language language, String text) {
        return PsiFileFactory.getInstance(this.getProject()).createFileFromText(fileName, language, (CharSequence)text, false, true);
    }
}

