/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Query;

public class AllClassesSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static final AllClassesSearch INSTANCE = new AllClassesSearch();

    public static Query<PsiClass> search(SearchScope scope, Project project) {
        return INSTANCE.createQuery(new SearchParameters(scope, project));
    }

    public static Query<PsiClass> search(SearchScope scope, Project project, Condition<String> shortNameCondition) {
        return INSTANCE.createQuery(new SearchParameters(scope, project, shortNameCondition));
    }

    public static class SearchParameters {
        private final SearchScope myScope;
        private final Project myProject;
        private final Condition<String> myShortNameCondition;

        public SearchParameters(SearchScope scope, Project project) {
            this(scope, project, (Condition<String>)Condition.TRUE);
        }

        public SearchParameters(SearchScope scope, Project project, Condition<String> shortNameCondition) {
            this.myScope = scope;
            this.myProject = project;
            this.myShortNameCondition = shortNameCondition;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public Project getProject() {
            return this.myProject;
        }

        public boolean nameMatches(String name) {
            return this.myShortNameCondition.value((Object)name);
        }
    }
}

