/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.ide.DataManager;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileDescriptor
implements Navigatable {
    public static final DataKey<Editor> NAVIGATE_IN_EDITOR = DataKey.create("NAVIGATE_IN_EDITOR");
    @NotNull
    private final VirtualFile myFile;
    private final int myOffset;
    private final int myLine;
    private final int myColumn;
    private final RangeMarker myRangeMarker;
    private final Project myProject;

    public OpenFileDescriptor(Project project, @NotNull VirtualFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/OpenFileDescriptor.<init> must not be null");
        }
        this(project, file, -1, -1, offset);
    }

    public OpenFileDescriptor(Project project, @NotNull VirtualFile file, int line, int col) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/OpenFileDescriptor.<init> must not be null");
        }
        this(project, file, line, col, -1);
    }

    public OpenFileDescriptor(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/OpenFileDescriptor.<init> must not be null");
        }
        this(project, file, -1, -1, -1);
    }

    private OpenFileDescriptor(Project project, @NotNull VirtualFile file, int line, int col, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/OpenFileDescriptor.<init> must not be null");
        }
        this.myProject = project;
        this.myFile = file;
        this.myLine = line;
        this.myColumn = col;
        this.myOffset = offset;
        this.myRangeMarker = offset >= 0 ? LazyRangeMarkerFactory.getInstance(project).createRangeMarker(file, offset) : (line >= 0 ? LazyRangeMarkerFactory.getInstance(project).createRangeMarker(file, line, Math.max(0, col)) : null);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/OpenFileDescriptor.getFile must not return null");
        }
        return virtualFile;
    }

    public int getOffset() {
        return this.myRangeMarker != null && this.myRangeMarker.isValid() ? this.myRangeMarker.getStartOffset() : this.myOffset;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getColumn() {
        return this.myColumn;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (!this.canNavigate()) {
            throw new IllegalStateException("Navigation is not possible with null project");
        }
        if (!this.myFile.isDirectory() && this.navigateInEditor(this.myProject, requestFocus)) {
            return;
        }
        this.navigateInProjectView();
    }

    private boolean navigateInEditor(Project project, boolean focusEditor) {
        FileType type = FileTypeManager.getInstance().getKnownFileTypeOrAssociate(this.myFile);
        if (type == null || !this.myFile.isValid()) {
            return false;
        }
        if (type instanceof NativeFileType) {
            return NativeFileType.openAssociatedApplication(this.myFile);
        }
        return this.navigateInRequestedEditor() || this.navigateInAnyFileEditor(project, focusEditor);
    }

    private boolean navigateInRequestedEditor() {
        DataContext ctx = DataManager.getInstance().getDataContext();
        Editor e = NAVIGATE_IN_EDITOR.getData(ctx);
        if (e == null) {
            return false;
        }
        if (FileDocumentManager.getInstance().getFile(e.getDocument()) != this.myFile) {
            return false;
        }
        this.navigateIn(e);
        return true;
    }

    private boolean navigateInAnyFileEditor(Project project, boolean focusEditor) {
        List<FileEditor> editors = FileEditorManager.getInstance(project).openEditor(this, focusEditor);
        return !editors.isEmpty();
    }

    private void navigateInProjectView() {
        SelectInContext context = new SelectInContext(){

            @Override
            @NotNull
            public Project getProject() {
                Project project = OpenFileDescriptor.this.myProject;
                if (project == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/OpenFileDescriptor$1.getProject must not return null");
                }
                return project;
            }

            @Override
            @NotNull
            public VirtualFile getVirtualFile() {
                VirtualFile virtualFile = OpenFileDescriptor.this.myFile;
                if (virtualFile == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/OpenFileDescriptor$1.getVirtualFile must not return null");
                }
                return virtualFile;
            }

            @Override
            @Nullable
            public Object getSelectorInFile() {
                return null;
            }

            @Override
            @Nullable
            public FileEditorProvider getFileEditorProvider() {
                return null;
            }
        };
        for (SelectInTarget target : SelectInManager.getInstance(this.myProject).getTargets()) {
            if (!target.canSelect(context)) continue;
            target.selectIn(context, true);
            return;
        }
    }

    public void navigateIn(Editor e) {
        if (this.getOffset() >= 0) {
            e.getCaretModel().moveToOffset(Math.min(this.getOffset(), e.getDocument().getTextLength()));
        } else if (this.getLine() != -1 && this.getColumn() != -1) {
            LogicalPosition pos = new LogicalPosition(this.getLine(), this.getColumn());
            e.getCaretModel().moveToLogicalPosition(pos);
        } else {
            return;
        }
        e.getSelectionModel().removeSelection();
        OpenFileDescriptor.scrollToCaret(e);
    }

    private static void scrollToCaret(final Editor e) {
        Project project = e.getProject();
        if (project != null) {
            IdeFocusManager.getInstance(project).doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    e.getScrollingModel().scrollToCaret(ScrollType.CENTER);
                }
            });
        } else {
            e.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    @Override
    public boolean canNavigate() {
        return this.myProject != null;
    }

    @Override
    public boolean canNavigateToSource() {
        return this.myProject != null;
    }

    public Project getProject() {
        return this.myProject;
    }
}

