/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UndoUtil {
    private UndoUtil() {
    }

    public static void markPsiFileForUndo(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/command/undo/UndoUtil.markPsiFileForUndo must not be null");
        }
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance(project).getDocument(file);
        if (document == null) {
            return;
        }
        DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
        UndoUtil.markDocumentReferenceForUndo(project, ref, "markDocumentForUndo: " + file);
    }

    public static void markVirtualFileForUndo(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/command/undo/UndoUtil.markVirtualFileForUndo must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/command/undo/UndoUtil.markVirtualFileForUndo must not be null");
        }
        DocumentReference ref = DocumentReferenceManager.getInstance().create(file);
        UndoUtil.markDocumentReferenceForUndo(project, ref, "markVirtualFileForUndo: " + file.getPath());
    }

    private static void markDocumentReferenceForUndo(Project project, final DocumentReference ref, final @NonNls String debugName) {
        UndoManager.getInstance(project).undoableActionPerformed(new UndoableAction(){

            @Override
            public void undo() {
            }

            @Override
            public void redo() {
            }

            @Override
            public DocumentReference[] getAffectedDocuments() {
                return new DocumentReference[]{ref};
            }

            @Override
            public boolean isGlobal() {
                return false;
            }

            @NonNls
            public String toString() {
                return debugName;
            }
        });
    }
}

