/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataKey<T> {
    private static final Map<String, DataKey> ourDataKeyIndex = new HashMap<String, DataKey>();
    private final String myName;

    private DataKey(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DataKey.<init> must not be null");
        }
        this.myName = name;
    }

    public static <T> DataKey<T> create(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DataKey.create must not be null");
        }
        if (ourDataKeyIndex.containsKey(name)) {
            return ourDataKeyIndex.get(name);
        }
        DataKey<T> key = new DataKey<T>(name);
        ourDataKeyIndex.put(name, key);
        return key;
    }

    public String getName() {
        return this.myName;
    }

    public final boolean is(String dataId) {
        return this.myName.equals(dataId);
    }

    @Nullable
    public T getData(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DataKey.getData must not be null");
        }
        return (T)dataContext.getData(this.myName);
    }

    @Nullable
    public T getData(DataProvider dataProvider) {
        return (T)dataProvider.getData(this.myName);
    }
}

