/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ExecutorService;
import javax.swing.SwingUtilities;

public abstract class AsyncUpdateAction<T>
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.AsyncUpdateAction");
    private static final ExecutorService ourUpdaterService = ConcurrencyUtil.newSingleThreadExecutor((String)"Action Updater");

    @Override
    public final void update(AnActionEvent e) {
        final T data = this.prepareDataFromContext(e);
        final Presentation originalPresentation = e.getPresentation();
        if (!this.forceSyncUpdate(e) && this instanceof DumbAware) {
            final Presentation realPresentation = (Presentation)originalPresentation.clone();
            ourUpdaterService.submit(new Runnable(){

                @Override
                public void run() {
                    AsyncUpdateAction.this.performUpdate(realPresentation, data);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (originalPresentation.isVisible() != realPresentation.isVisible()) {
                                LOG.error("Async update is not supported for actions that change their visibility.Either stop extending AsyncUpdateAction or override forceSyncUpdate() to return true.Action class is: " + AsyncUpdateAction.this.getClass().getName());
                            }
                            originalPresentation.copyFrom(realPresentation);
                        }
                    });
                }
            });
            originalPresentation.setVisible(true);
            originalPresentation.setEnabled(false);
        } else {
            this.performUpdate(originalPresentation, data);
        }
    }

    @Override
    public final void beforeActionPerformedUpdate(AnActionEvent e) {
        this.performUpdate(e.getPresentation(), this.prepareDataFromContext(e));
    }

    protected abstract T prepareDataFromContext(AnActionEvent var1);

    protected abstract void performUpdate(Presentation var1, T var2);

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return false;
    }
}

