/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeToolState {
    private NamedScope myScope;
    private final String myScopeName;
    private InspectionProfileEntry myTool;
    private boolean myEnabled;
    private HighlightDisplayLevel myLevel;
    private JComponent myAdditionalConfigPanel;
    private static final Logger LOG = Logger.getInstance((String)("#" + ScopeToolState.class.getName()));

    public ScopeToolState(NamedScope scope, @NotNull InspectionProfileEntry tool, boolean enabled, HighlightDisplayLevel level) {
        if (tool == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/ScopeToolState.<init> must not be null");
        }
        this.myScope = scope;
        this.myScopeName = this.myScope.getName();
        this.myTool = tool;
        this.myEnabled = enabled;
        this.myLevel = level;
    }

    public ScopeToolState(String scopeName, InspectionProfileEntry tool, boolean enabled, HighlightDisplayLevel level) {
        this.myScopeName = scopeName;
        this.myTool = tool;
        this.myEnabled = enabled;
        this.myLevel = level;
    }

    @Nullable
    public NamedScope getScope() {
        Project project;
        if (this.myScope == null && (project = PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext())) != null) {
            this.myScope = NamedScopesHolder.getScope(project, this.myScopeName);
        }
        return this.myScope;
    }

    public String getScopeName() {
        return this.myScopeName;
    }

    @NotNull
    public InspectionProfileEntry getTool() {
        InspectionProfileEntry inspectionProfileEntry = this.myTool;
        if (inspectionProfileEntry == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/ScopeToolState.getTool must not return null");
        }
        return inspectionProfileEntry;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public HighlightDisplayLevel getLevel() {
        return this.myLevel;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void setLevel(HighlightDisplayLevel level) {
        this.myLevel = level;
    }

    @Nullable
    public JComponent getAdditionalConfigPanel() {
        if (this.myAdditionalConfigPanel == null) {
            this.myAdditionalConfigPanel = this.myTool.createOptionsPanel();
            if (this.myAdditionalConfigPanel == null) {
                this.myAdditionalConfigPanel = new JPanel();
            }
            return this.myAdditionalConfigPanel;
        }
        return this.myAdditionalConfigPanel;
    }

    public void resetConfigPanel() {
        this.myAdditionalConfigPanel = null;
    }

    public void setTool(InspectionProfileEntry tool) {
        this.myTool = tool;
    }

    public boolean equalTo(ScopeToolState state2) {
        if (this.isEnabled() != state2.isEnabled()) {
            return false;
        }
        if (this.getLevel() != state2.getLevel()) {
            return false;
        }
        try {
            String tempRoot = "root";
            Element oldToolSettings = new Element(tempRoot);
            this.getTool().writeSettings(oldToolSettings);
            Element newToolSettings = new Element(tempRoot);
            state2.getTool().writeSettings(newToolSettings);
            return JDOMUtil.areElementsEqual((Element)oldToolSettings, (Element)newToolSettings);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }
}

