/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ImageLoader;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.Map;
import javax.swing.Icon;

public class HighlightDisplayLevel {
    private static final Icon EMPTY = new EmptyIcon(12, 12);
    private static final Map<HighlightSeverity, HighlightDisplayLevel> ourMap = new HashMap();
    public static final HighlightDisplayLevel GENERIC_SERVER_ERROR_OR_WARNING = new HighlightDisplayLevel(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, HighlightDisplayLevel.createIconByMask(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING.getDefaultAttributes().getErrorStripeColor()));
    public static final HighlightDisplayLevel ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR, HighlightDisplayLevel.createIconByMask(CodeInsightColors.ERRORS_ATTRIBUTES.getDefaultAttributes().getErrorStripeColor()));
    public static final HighlightDisplayLevel WARNING = new HighlightDisplayLevel(HighlightSeverity.WARNING, HighlightDisplayLevel.createIconByMask(CodeInsightColors.WARNINGS_ATTRIBUTES.getDefaultAttributes().getErrorStripeColor()));
    public static final HighlightDisplayLevel DO_NOT_SHOW = new HighlightDisplayLevel(HighlightSeverity.INFORMATION, HighlightDisplayLevel.createIconByMask(new Color(30, 160, 0)));
    public static final HighlightDisplayLevel INFO = new HighlightDisplayLevel(HighlightSeverity.INFO, DO_NOT_SHOW.getIcon());
    private Icon myIcon;
    private final HighlightSeverity mySeverity;

    public static HighlightDisplayLevel find(String name) {
        for (HighlightSeverity severity : ourMap.keySet()) {
            if (!Comparing.strEqual((String)severity.toString(), (String)name)) continue;
            return ourMap.get(severity);
        }
        return null;
    }

    public static HighlightDisplayLevel find(HighlightSeverity severity) {
        return ourMap.get(severity);
    }

    public HighlightDisplayLevel(HighlightSeverity severity, Icon icon) {
        this.mySeverity = severity;
        this.myIcon = icon;
        ourMap.put(this.mySeverity, this);
    }

    public String toString() {
        return this.mySeverity.toString();
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public HighlightSeverity getSeverity() {
        return this.mySeverity;
    }

    public static void registerSeverity(HighlightSeverity severity, Color renderColor) {
        Icon severityIcon = HighlightDisplayLevel.createIconByMask(renderColor);
        HighlightDisplayLevel level = ourMap.get(severity);
        if (level == null) {
            new HighlightDisplayLevel(severity, severityIcon);
        } else {
            level.myIcon = severityIcon;
        }
    }

    public static Icon createIconByMask(final Color renderColor) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                g2.drawImage(ImageHolder.ourErrorMaskImage, 1, 2, renderColor, null);
            }

            @Override
            public int getIconWidth() {
                return EMPTY.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return EMPTY.getIconHeight();
            }
        };
    }

    private static class ImageHolder {
        private static final Image ourErrorMaskImage = ImageLoader.loadFromResource((String)"/general/errorMask.png");

        private ImageHolder() {
        }
    }
}

