/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.lw.FontDescriptor;
import com.intellij.uiDesigner.propertyInspector.properties.IntroFontProperty;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class FontEditorDialog
extends DialogWrapper {
    private JList myFontNameList;
    private JList myFontStyleList;
    private JList myFontSizeList;
    private JPanel myRootPane;
    private JLabel myPreviewTextLabel;
    private JTextField myFontNameEdit;
    private JTextField myFontStyleEdit;
    private JSpinner myFontSizeEdit;
    private JList mySwingFontList;
    private JTabbedPane myTabbedPane;
    private JCheckBox myFontNameCheckbox;
    private JCheckBox myFontStyleCheckbox;
    private JCheckBox myFontSizeCheckbox;
    private FontDescriptor myValue;

    protected FontEditorDialog(Project project, String propertyName) {
        super(project, false);
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(UIDesignerBundle.message("font.chooser.title", propertyName));
        this.myFontNameList.setListData(UIUtil.getValidFontNames((boolean)true));
        this.myFontNameList.addListSelectionListener(new MyListSelectionListener(this.myFontNameEdit));
        this.myFontStyleList.setListData(new String[]{UIDesignerBundle.message("font.chooser.regular", new Object[0]), UIDesignerBundle.message("font.chooser.bold", new Object[0]), UIDesignerBundle.message("font.chooser.italic", new Object[0]), UIDesignerBundle.message("font.chooser.bold.italic", new Object[0])});
        this.myFontStyleList.addListSelectionListener(new MyListSelectionListener(this.myFontStyleEdit));
        this.myFontSizeList.setListData(UIUtil.getStandardFontSizes());
        this.myFontSizeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Integer selValue = Integer.valueOf(FontEditorDialog.this.myFontSizeList.getSelectedValue().toString());
                FontEditorDialog.this.myFontSizeEdit.setValue(selValue);
                FontEditorDialog.this.updateValue();
            }
        });
        this.myFontSizeEdit.setModel(new SpinnerNumberModel(3, 3, 96, 1));
        this.myFontSizeEdit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FontEditorDialog.this.myFontSizeList.setSelectedValue(FontEditorDialog.this.myFontSizeEdit.getValue().toString(), true);
                FontEditorDialog.this.updateValue();
            }
        });
        this.mySwingFontList.setListData(FontEditorDialog.collectSwingFontDescriptors());
        this.mySwingFontList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                FontDescriptor descriptor = (FontDescriptor)value;
                this.clear();
                this.append(descriptor.getSwingFont(), selected ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
                this.append(" (" + FontEditorDialog.fontToString(UIManager.getFont(descriptor.getSwingFont())) + ")", selected ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        });
        this.mySwingFontList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FontEditorDialog.this.myValue = (FontDescriptor)FontEditorDialog.this.mySwingFontList.getSelectedValue();
                FontEditorDialog.this.updatePreview();
            }
        });
        this.myFontNameCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FontEditorDialog.this.myFontNameList.setEnabled(FontEditorDialog.this.myFontNameCheckbox.isSelected());
                FontEditorDialog.this.updateValue();
            }
        });
        this.myFontStyleCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FontEditorDialog.this.myFontStyleList.setEnabled(FontEditorDialog.this.myFontStyleCheckbox.isSelected());
                FontEditorDialog.this.updateValue();
            }
        });
        this.myFontSizeCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FontEditorDialog.this.myFontSizeList.setEnabled(FontEditorDialog.this.myFontSizeCheckbox.isSelected());
                FontEditorDialog.this.myFontSizeEdit.setEnabled(FontEditorDialog.this.myFontSizeCheckbox.isSelected());
                FontEditorDialog.this.updateValue();
            }
        });
    }

    private static String fontToString(Font font) {
        StringBuilder result = new StringBuilder(font.getFamily());
        result.append(" ").append(font.getSize());
        if ((font.getStyle() & 1) != 0) {
            result.append(" ").append(UIDesignerBundle.message("font.chooser.bold", new Object[0]));
        }
        if ((font.getStyle() & 2) != 0) {
            result.append(" ").append(UIDesignerBundle.message("font.chooser.bold", new Object[0]));
        }
        return result.toString();
    }

    private static FontDescriptor[] collectSwingFontDescriptors() {
        ArrayList<FontDescriptor> result = new ArrayList<FontDescriptor>();
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration e = defaults.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = defaults.get(key);
            if (!(key instanceof String) || !(value instanceof Font)) continue;
            result.add(FontDescriptor.fromSwingFont((String)((String)key)));
        }
        Collections.sort(result, new Comparator<FontDescriptor>(){

            @Override
            public int compare(FontDescriptor o1, FontDescriptor o2) {
                return o1.getSwingFont().compareTo(o2.getSwingFont());
            }
        });
        return result.toArray(new FontDescriptor[result.size()]);
    }

    public FontDescriptor getValue() {
        return this.myValue;
    }

    public void setValue(@NotNull FontDescriptor value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/propertyInspector/editors/FontEditorDialog.setValue must not be null");
        }
        this.myValue = value;
        if (value.getSwingFont() != null) {
            this.myTabbedPane.setSelectedIndex(1);
            this.mySwingFontList.setSelectedValue(this.myValue, true);
        } else {
            this.myFontNameCheckbox.setSelected(value.getFontName() != null);
            this.myFontSizeCheckbox.setSelected(value.getFontSize() >= 0);
            this.myFontStyleCheckbox.setSelected(value.getFontStyle() >= 0);
            this.myFontNameList.setSelectedValue(value.getFontName(), true);
            this.myFontStyleList.setSelectedIndex(value.getFontStyle());
            if (value.getFontSize() >= 0) {
                this.myFontSizeList.setSelectedValue(Integer.toString(value.getFontSize()), true);
                if (this.myFontSizeList.getSelectedIndex() < 0) {
                    this.myFontSizeEdit.setValue(new Integer(value.getFontSize()));
                }
            } else {
                this.myFontSizeList.setSelectedIndex(-1);
                this.myFontSizeEdit.setValue(0);
            }
        }
    }

    private void updateValue() {
        int fontSize = (Integer)this.myFontSizeEdit.getValue();
        this.myValue = new FontDescriptor(this.myFontNameCheckbox.isSelected() ? (String)this.myFontNameList.getSelectedValue() : null, this.myFontStyleCheckbox.isSelected() ? this.myFontStyleList.getSelectedIndex() : -1, this.myFontSizeCheckbox.isSelected() ? fontSize : -1);
        this.updatePreview();
    }

    private void updatePreview() {
        this.myPreviewTextLabel.setText(IntroFontProperty.descriptorToString(this.myValue));
        this.myPreviewTextLabel.setFont(this.myValue.getResolvedFont(this.myRootPane.getFont()));
    }

    protected JComponent createCenterPanel() {
        return this.myRootPane;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JList jList;
        JSpinner jSpinner;
        JTextField jTextField;
        JTextField jTextField2;
        JList jList2;
        JList jList3;
        JList jList4;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JTabbedPane jTabbedPane;
        JPanel jPanel;
        this.myRootPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTabbedPane = jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 5, 5, 5), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("messages/UIDesignerBundle").getString("font.chooser.font.tab"), null, jPanel2, null);
        this.myFontNameCheckbox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("font.chooser.font"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFontStyleCheckbox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("font.chooser.style"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFontSizeCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("font.chooser.size"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myFontNameList = jList4 = new JList();
        ((Component)jList4).setEnabled(false);
        jList4.setSelectionMode(0);
        jScrollPane.setViewportView(jList4);
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel2.add((Component)jScrollPane2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myFontStyleList = jList3 = new JList();
        ((Component)jList3).setEnabled(false);
        jList3.setSelectionMode(0);
        jScrollPane2.setViewportView(jList3);
        JScrollPane jScrollPane3 = new JScrollPane();
        jPanel2.add((Component)jScrollPane3, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myFontSizeList = jList2 = new JList();
        ((Component)jList2).setEnabled(false);
        jList2.setSelectionMode(0);
        jScrollPane3.setViewportView(jList2);
        this.myFontNameEdit = jTextField2 = new JTextField();
        ((Component)jTextField2).setEnabled(false);
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFontStyleEdit = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        this.myFontSizeEdit = jSpinner = new JSpinner();
        ((Component)jSpinner).setEnabled(false);
        jPanel2.add((Component)jSpinner, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("messages/UIDesignerBundle").getString("font.chooser.swing.tab"), null, jPanel3, null);
        JScrollPane jScrollPane4 = new JScrollPane();
        jPanel3.add((Component)jScrollPane4, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.mySwingFontList = jList = new JList();
        jList.setSelectionMode(0);
        jScrollPane4.setViewportView(jList);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("font.chooser.preview.text"), 0, 0, null, null));
        this.myPreviewTextLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(200, 40), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private final JTextField myTextField;

        public MyListSelectionListener(JTextField textField) {
            this.myTextField = textField;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            JList sourceList = (JList)e.getSource();
            Object selValue = sourceList.getSelectedValue();
            if (selValue != null) {
                this.myTextField.setText(selValue.toString());
            } else {
                this.myTextField.setText("");
            }
            FontEditorDialog.this.updateValue();
        }
    }
}

