/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LineRange {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.LineRange");
    final int startLine;
    final int endLine;
    PsiElement firstElement;
    PsiElement lastElement;

    public LineRange(int startLine, int endLine) {
        this.startLine = startLine;
        this.endLine = endLine;
        if (startLine > endLine) {
            LOG.error("start > end: start=" + startLine + "; end=" + endLine);
        }
    }

    public LineRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull Document document) {
        if (startElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/actions/moveUpDown/LineRange.<init> must not be null");
        }
        if (endElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/actions/moveUpDown/LineRange.<init> must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/actions/moveUpDown/LineRange.<init> must not be null");
        }
        this(document.getLineNumber(startElement.getTextRange().getStartOffset()), document.getLineNumber(endElement.getTextRange().getEndOffset()) + 1);
        this.firstElement = startElement;
        this.lastElement = endElement;
    }

    @NonNls
    public String toString() {
        return "line range: [" + this.startLine + "-" + this.endLine + "]";
    }
}

