/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GroovyDslAnnotator
implements Annotator {
    public void annotate(PsiElement psiElement, AnnotationHolder holder) {
        GroovyFile file;
        VirtualFile vfile;
        if (psiElement instanceof GroovyFile && (vfile = (file = (GroovyFile)psiElement).getVirtualFile()) != null && "gdsl".equals(vfile.getExtension()) && !GroovyDslFileIndex.isActivated(vfile)) {
            Annotation annotation = holder.createWarningAnnotation((PsiElement)file, "DSL descriptor file has been changed and isn't currently executed. Click to activate it back.");
            annotation.setFileLevelAnnotation(true);
            annotation.registerFix(new IntentionAction(){

                @NotNull
                public String getText() {
                    if ("Activate" == null) {
                        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator$1.getText must not return null");
                    }
                    return "Activate";
                }

                @NotNull
                public String getFamilyName() {
                    if ("Activate DSL descriptor" == null) {
                        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator$1.getFamilyName must not return null");
                    }
                    return "Activate DSL descriptor";
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator$1.isAvailable must not be null");
                    }
                    return true;
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator$1.invoke must not be null");
                    }
                    GroovyDslFileIndex.activateUntilModification(vfile);
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                }

                public boolean startInWriteAction() {
                    return false;
                }
            });
        }
    }
}

