/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.utils.LibraryUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyMethodParameterCountInspection
extends GroovyMethodMetricInspection {
    @NotNull
    public String getDisplayName() {
        if ("Method with too many parameters" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMethodParameterCountInspection.getDisplayName must not return null");
        }
        return "Method with too many parameters";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Method Metrics" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMethodParameterCountInspection.getGroupDisplayName must not return null");
        }
        return "Method Metrics";
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return "Maximum number of parameters:";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' contains too many parameters (" + args[0] + '>' + args[1] + ')';
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(GrMethod grMethod) {
            super.visitMethod(grMethod);
            GrParameter[] parameters = grMethod.getParameters();
            int limit = GroovyMethodParameterCountInspection.this.getLimit();
            if (parameters == null || parameters.length < limit) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(grMethod)) {
                return;
            }
            this.registerMethodError(grMethod, parameters.length, limit);
        }
    }
}

