/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;

public class GroovyEmptyStatementBodyInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        if ("Statement with empty body" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyEmptyStatementBodyInspection.getDisplayName must not return null");
        }
        return "Statement with empty body";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Potentially confusing code constructs" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyEmptyStatementBodyInspection.getGroupDisplayName must not return null");
        }
        return "Potentially confusing code constructs";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        if (args[0] instanceof GrIfStatement) {
            return "'#ref' Statement has empty branch";
        }
        return "'#ref' Statement has empty body";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitWhileStatement(@NotNull GrWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyEmptyStatementBodyInspection$Visitor.visitWhileStatement must not be null");
            }
            super.visitWhileStatement(statement);
            GrStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (!Visitor.isEmpty(body)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        @Override
        public void visitForStatement(@NotNull GrForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyEmptyStatementBodyInspection$Visitor.visitForStatement must not be null");
            }
            super.visitForStatement(statement);
            GrStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (!Visitor.isEmpty(body)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyEmptyStatementBodyInspection$Visitor.visitIfStatement must not be null");
            }
            super.visitIfStatement(statement);
            GrStatement thenBranch = statement.getThenBranch();
            if (thenBranch != null && Visitor.isEmpty(thenBranch)) {
                this.registerStatementError(statement, statement);
                return;
            }
            GrStatement elseBranch = statement.getElseBranch();
            if (elseBranch != null && Visitor.isEmpty(elseBranch)) {
                this.registerStatementError(statement, statement);
            }
        }

        private static boolean isEmpty(GroovyPsiElement body) {
            if (!(body instanceof GrBlockStatement)) {
                return false;
            }
            GrBlockStatement block = (GrBlockStatement)body;
            GrStatement[] statements = block.getBlock().getStatements();
            return statements.length == 0;
        }
    }
}

